/*
 * Decompiled with CFR 0.152.
 */
package com.github.reallysub.angels.common.events;

import com.github.reallysub.angels.common.WAObjects;
import com.github.reallysub.angels.common.WorldGenArms;
import com.github.reallysub.angels.common.capability.CapabilityAngelSickness;
import com.github.reallysub.angels.common.capability.IAngelSickness;
import com.github.reallysub.angels.main.Utils;
import com.github.reallysub.angels.main.config.Config;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber
public class CommonEvents {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        EntityPlayer player = e.player;
        if (!player.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            Utils.getAllAngels(player, 40, 40.0);
            if (player.field_70170_p.field_73012_v.nextInt(20) == 5 && !player.func_184812_l_() && Config.infection) {
                if (Utils.getViewedTicks(player) >= 8200) {
                    player.func_146105_b((ITextComponent)new TextComponentString("You must look away from this angel!"), true);
                }
                if (Utils.getViewedTicks(player) >= 12200) {
                    player.func_146105_b((ITextComponent)new TextComponentString("You have been infected by a Weeping Angel, you will now die."), true);
                    player.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 600, 1));
                }
            }
        }
    }

    @SubscribeEvent
    public static void decorBiomeEvent(DecorateBiomeEvent e) {
        if (e.getWorld().func_180494_b(e.getPos()).func_150559_j()) {
            WorldGenArms arms = new WorldGenArms(WAObjects.angelArm);
            if (e.getRand().nextInt(30) <= 10) {
                arms.func_180709_b(e.getWorld(), e.getRand(), e.getPos());
            }
        }
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer) || ((Entity)event.getObject()).hasCapability(CapabilityAngelSickness.CAP, null)) {
            return;
        }
        event.addCapability(new ResourceLocation("weeping-angels", "angelsickness"), (ICapabilityProvider)new CapabilityAngelSickness.CapabilityAngelSicknessProvider(new CapabilityAngelSickness((EntityPlayer)event.getObject())));
    }

    @SubscribeEvent
    public void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget().hasCapability(CapabilityAngelSickness.CAP, null)) {
            ((IAngelSickness)event.getTarget().getCapability(CapabilityAngelSickness.CAP, null)).sync();
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        NBTTagCompound nbt = (NBTTagCompound)CapabilityAngelSickness.CAP.getStorage().writeNBT(CapabilityAngelSickness.CAP, event.getOriginal().getCapability(CapabilityAngelSickness.CAP, null), null);
        CapabilityAngelSickness.CAP.getStorage().readNBT(CapabilityAngelSickness.CAP, event.getEntityPlayer().getCapability(CapabilityAngelSickness.CAP, null), null, (NBTBase)nbt);
    }
}

