/*
 * Decompiled with CFR 0.152.
 */
package com.github.reallysub.angels.common.entities;

import com.github.reallysub.angels.client.EventTeleport;
import com.github.reallysub.angels.common.WAObjects;
import com.github.reallysub.angels.main.Utils;
import com.github.reallysub.angels.main.config.Config;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class EntityAngel
extends EntityMob {
    BlockPos nullPos = BlockPos.field_177992_a;
    private static DataParameter<Boolean> isAngry = EntityDataManager.func_187226_a(EntityAngel.class, (DataSerializer)DataSerializers.field_187198_h);
    private static DataParameter<Boolean> isSeen = EntityDataManager.func_187226_a(EntityAngel.class, (DataSerializer)DataSerializers.field_187198_h);
    private static DataParameter<Integer> timeViewed = EntityDataManager.func_187226_a(EntityAngel.class, (DataSerializer)DataSerializers.field_187192_b);
    private static DataParameter<Integer> type = EntityDataManager.func_187226_a(EntityAngel.class, (DataSerializer)DataSerializers.field_187192_b);
    private static DataParameter<BlockPos> blockBreakPos = EntityDataManager.func_187226_a(EntityAngel.class, (DataSerializer)DataSerializers.field_187200_j);
    private static DataParameter<Boolean> isChild = EntityDataManager.func_187226_a(EntityAngel.class, (DataSerializer)DataSerializers.field_187198_h);
    private int timer = 0;

    public EntityAngel(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 3.0, 80.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 3.0, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70728_aV = 25;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187843_fX;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_70631_g_() && this.field_70146_Z.nextInt(10) == 5) {
            return WAObjects.laughing_child;
        }
        return null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(35.0);
    }

    public boolean func_70652_k(Entity entity) {
        if (this.field_70146_Z.nextInt(4) < 2) {
            entity.func_70097_a(WAObjects.ANGEL, 4.0f);
        } else {
            entity.func_70097_a(WAObjects.ANGEL_NECK_SNAP, 4.0f);
        }
        return super.func_70652_k(entity);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(isSeen, (Object)false);
        this.func_184212_Q().func_187214_a(isAngry, (Object)false);
        this.func_184212_Q().func_187214_a(isChild, (Object)this.randomChild());
        this.func_184212_Q().func_187214_a(timeViewed, (Object)0);
        this.func_184212_Q().func_187214_a(type, (Object)this.randomType());
        this.func_184212_Q().func_187214_a(blockBreakPos, (Object)new BlockPos(0, 0, 0));
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (!this.isSeen() || !this.field_70122_E) {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150348_b), this.field_70146_Z.nextInt(5));
    }

    protected void func_70664_aZ() {
        if (!this.isSeen()) {
            super.func_70664_aZ();
        }
    }

    public BlockPos getBreakPos() {
        return (BlockPos)this.func_184212_Q().func_187225_a(blockBreakPos);
    }

    public void setBreakBlockPos(BlockPos pos) {
        this.func_184212_Q().func_187227_b(blockBreakPos, (Object)pos);
    }

    public boolean isSeen() {
        return (Boolean)this.func_184212_Q().func_187225_a(isSeen);
    }

    public boolean isAngry() {
        return (Boolean)this.func_184212_Q().func_187225_a(isAngry);
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(isChild);
    }

    public void setAngry(boolean angry) {
        this.func_184212_Q().func_187227_b(isAngry, (Object)angry);
    }

    public void setSeen(boolean beingViewed) {
        this.func_184212_Q().func_187227_b(isSeen, (Object)beingViewed);
    }

    public void setChild(boolean child) {
        this.func_184212_Q().func_187227_b(isChild, (Object)child);
    }

    public int getSeenTime() {
        return (Integer)this.func_184212_Q().func_187225_a(timeViewed);
    }

    public int getType() {
        return (Integer)this.func_184212_Q().func_187225_a(type);
    }

    public void setType(int angelType) {
        this.func_184212_Q().func_187227_b(type, (Object)angelType);
    }

    public void setSeenTime(int time) {
        this.func_184212_Q().func_187227_b(timeViewed, (Object)time);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("isSeen", this.isSeen());
        compound.func_74768_a("timeSeen", this.getSeenTime());
        compound.func_74757_a("isAngry", this.isAngry());
        compound.func_74768_a("type", this.getType());
        compound.func_74757_a("angelChild", this.func_70631_g_());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("isSeen")) {
            this.setSeen(compound.func_74767_n("isSeen"));
        }
        if (compound.func_74764_b("timeSeen")) {
            this.setSeenTime(compound.func_74762_e("timeSeen"));
        }
        if (compound.func_74764_b("isAngry")) {
            this.setAngry(compound.func_74767_n("isAngry"));
        }
        if (compound.func_74764_b("type")) {
            this.setType(compound.func_74762_e("type"));
        }
        if (compound.func_74764_b("angelChild")) {
            this.setChild(compound.func_74767_n("angelChild"));
        }
    }

    protected void func_82167_n(Entity entity) {
        entity.func_70108_f((Entity)this);
        if (!(!Config.teleportEntities || this.func_70631_g_() || entity instanceof EntityAngel || this.field_70146_Z.nextInt(100) != 50 || entity instanceof EntityPainting || entity instanceof EntityItemFrame || entity instanceof EntityItem || entity instanceof EntityArrow || entity instanceof EntityThrowable)) {
            int x = entity.func_180425_c().func_177958_n() + this.field_70146_Z.nextInt(Config.teleportRange);
            int z = entity.func_180425_c().func_177952_p() + this.field_70146_Z.nextInt(Config.teleportRange);
            int y = this.field_70170_p.func_189649_b(x, z);
            Utils.teleportEntity(this.field_70170_p, entity, x, y, z);
            this.func_70691_i(4.0f);
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (this.field_70146_Z.nextInt(10) == 2) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 600, 3));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 600, 1));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 600, 3));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 600, 3));
                }
                MinecraftForge.EVENT_BUS.post((Event)new EventTeleport(player));
            }
        }
    }

    protected boolean func_70610_aX() {
        return this.func_110143_aJ() <= 0.0f || this.isSeen();
    }

    protected void func_70101_b(float yaw, float pitch) {
        if (!this.isSeen()) {
            super.func_70101_b(yaw, pitch);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.isSeen() && this.field_70146_Z.nextInt(15) == 5) {
            this.setAngry(!this.isAngry());
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isSeen()) {
                this.setSeenTime(this.getSeenTime() + 1);
                if (this.getSeenTime() > 15) {
                    this.setSeen(false);
                }
            } else {
                this.setSeenTime(0);
            }
        }
        if (this.isSeen() && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
            this.replaceBlocks(this.func_174813_aQ().func_72314_b(25.0, 25.0, 25.0));
        }
    }

    @SubscribeEvent
    public static void cancelDamage(LivingAttackEvent e) {
        if (e.getSource().func_76346_g() != null) {
            EntityLivingBase attacker = (EntityLivingBase)e.getSource().func_76346_g();
            EntityLivingBase victim = e.getEntityLiving();
            if (victim instanceof EntityAngel) {
                ItemStack item = attacker.func_184582_a(EntityEquipmentSlot.MAINHAND);
                boolean isPic = item.func_77973_b() instanceof ItemPickaxe;
                e.setCanceled(!isPic);
                if (!isPic) {
                    attacker.func_70097_a(WAObjects.STONE, 2.5f);
                } else {
                    ItemPickaxe pick = (ItemPickaxe)item.func_77973_b();
                    pick.setDamage(item, pick.getDamage(item) - 1);
                }
            }
        }
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        if (this.field_70169_q != this.field_70165_t && this.field_70166_s != this.field_70161_v) {
            if (!this.func_70631_g_()) {
                this.func_184185_a(WAObjects.stone_scrap, 0.5f, 1.0f);
            } else {
                this.func_184185_a(WAObjects.child_run, 1.0f, 1.0f);
            }
        }
    }

    private void replaceBlocks(AxisAlignedBB box) {
        int x = (int)box.field_72340_a;
        while ((double)x <= box.field_72336_d) {
            int y = (int)box.field_72338_b;
            while ((double)y <= box.field_72337_e) {
                int z = (int)box.field_72339_c;
                while ((double)z <= box.field_72334_f) {
                    int i;
                    BlockPos pos = new BlockPos(x, y, z);
                    Block block = this.func_130014_f_().func_180495_p(pos).func_177230_c();
                    if ((block == Blocks.field_150478_aa || block == Blocks.field_150429_aA || block == Blocks.field_150426_aN) && this.shouldBreak()) {
                        for (i = 0; i < 21; ++i) {
                            ++this.timer;
                            this.setBreakBlockPos(pos);
                            if (!this.field_70170_p.field_72995_K) continue;
                            this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT_MAGIC, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0, 1.0, 1.0, new int[0]);
                        }
                        if (this.timer > 20) {
                            this.func_130014_f_().func_175698_g(pos);
                            this.timer = 0;
                            this.func_184185_a(WAObjects.light_break, 1.0f, 1.0f);
                            this.setBreakBlockPos(this.nullPos);
                        }
                    }
                    if (block == Blocks.field_150428_aP) {
                        this.setBreakBlockPos(pos);
                        if (this.shouldBreak()) {
                            for (i = 0; i < 21; ++i) {
                                ++this.timer;
                                this.setBreakBlockPos(pos);
                                if (!this.field_70170_p.field_72995_K) continue;
                                this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT_MAGIC, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0, 1.0, 1.0, new int[0]);
                            }
                            if (this.timer > 20) {
                                this.func_130014_f_().func_175698_g(pos);
                                this.timer = 0;
                                this.func_184185_a(WAObjects.light_break, 1.0f, 1.0f);
                                this.setBreakBlockPos(this.nullPos);
                            }
                        }
                        this.func_130014_f_().func_175656_a(pos, Blocks.field_150423_aK.func_176223_P());
                    }
                    if (block == Blocks.field_150374_bv) {
                        if (this.shouldBreak()) {
                            for (i = 0; i < 21; ++i) {
                                ++this.timer;
                                this.setBreakBlockPos(pos);
                                if (!this.field_70170_p.field_72995_K) continue;
                                this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT_MAGIC, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0, 1.0, 1.0, new int[0]);
                            }
                        }
                        if (this.timer > 20) {
                            this.func_130014_f_().func_175698_g(pos);
                            this.timer = 0;
                            this.func_184185_a(WAObjects.light_break, 1.0f, 1.0f);
                            this.setBreakBlockPos(this.nullPos);
                        }
                        this.func_130014_f_().func_175656_a(pos, Blocks.field_150379_bu.func_176223_P());
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private boolean shouldBreak() {
        return this.func_110143_aJ() > 5.0f && this.field_70146_Z.nextInt(10) < 5;
    }

    private int randomType() {
        if (this.field_70146_Z.nextBoolean()) {
            return 1;
        }
        return 0;
    }

    private boolean randomChild() {
        return this.field_70146_Z.nextInt(10) == 4;
    }
}

