/*
 * Decompiled with CFR 0.152.
 */
package com.github.reallysub.angels.common;

import com.github.reallysub.angels.client.models.ModelAngelEd;
import com.github.reallysub.angels.client.render.entity.RenderAngel;
import com.github.reallysub.angels.client.render.entity.RenderAngelPainting;
import com.github.reallysub.angels.client.render.tiles.RenderSnowArm;
import com.github.reallysub.angels.common.blocks.BlockSnowArm;
import com.github.reallysub.angels.common.entities.EntityAngel;
import com.github.reallysub.angels.common.entities.EntityPainting2;
import com.github.reallysub.angels.common.items.ItemHanging;
import com.github.reallysub.angels.common.tiles.TileSnowArm;
import com.github.reallysub.angels.main.config.Config;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="weeping-angels")
public class WAObjects {
    private static List<SoundEvent> SOUNDS = new ArrayList<SoundEvent>();
    public static SoundEvent angelSeen = WAObjects.addSound("angel_seen");
    public static SoundEvent stone_scrap = WAObjects.addSound("stone_scrap");
    public static SoundEvent child_run = WAObjects.addSound("child_run");
    public static SoundEvent laughing_child = WAObjects.addSound("laughing_child");
    public static SoundEvent light_break = WAObjects.addSound("light_break");
    public static DamageSource ANGEL = new WADamageSource("was sent back in time by a Angel!");
    public static DamageSource STONE = new WADamageSource("broke their bones by punching stone...");
    public static DamageSource ANGEL_NECK_SNAP = new WADamageSource("has their neck snapped by a Angel!");
    private static int entityID = 0;
    public static Block angelArm = new BlockSnowArm();
    public static Item angelPainting = WAObjects.createItem(new ItemHanging(), "angel_painting");
    public static Item angelArmItem = WAObjects.createItem((Item)new ItemBlock(angelArm), "arm").func_77637_a(CreativeTabs.field_78031_c);

    private static SoundEvent addSound(String soundName) {
        ResourceLocation sound = new ResourceLocation("weeping-angels:" + soundName);
        SoundEvent s = (SoundEvent)new SoundEvent(sound).setRegistryName(soundName);
        SOUNDS.add(s);
        return s;
    }

    public static void setUpSpawns() {
        List allBiomes = ForgeRegistries.BIOMES.getValues();
        ArrayList spawn = Lists.newArrayList();
        spawn.addAll(allBiomes);
        for (Biome biome : spawn) {
            if (biome == null) continue;
            EntityRegistry.addSpawn(EntityAngel.class, (int)Config.spawnProbability, (int)Config.minimumSpawn, (int)Config.maximumSpawn, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])new Biome[]{biome});
        }
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> e) {
        SoundEvent[] sounds = SOUNDS.toArray(new SoundEvent[SOUNDS.size()]);
        e.getRegistry().registerAll((IForgeRegistryEntry[])sounds);
    }

    private static <E extends Entity> EntityEntryBuilder<E> createBuilder(String name) {
        EntityEntryBuilder builder = EntityEntryBuilder.create();
        ResourceLocation registryName = new ResourceLocation("weeping-angels:" + name);
        return builder.id(registryName, entityID++).name(registryName.toString().replaceAll("weeping-angels:", ""));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        GameRegistry.registerTileEntity(TileSnowArm.class, (String)":snowarm");
        event.getRegistry().register((IForgeRegistryEntry)angelArm);
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        EntityEntry[] entries = new EntityEntry[]{WAObjects.createBuilder("weepingAngel").entity(EntityAngel.class).egg(184, 286).tracker(80, 3, false).build(), WAObjects.createBuilder("weepingAngelpainting").entity(EntityPainting2.class).tracker(160, Integer.MAX_VALUE, false).build()};
        event.getRegistry().registerAll((IForgeRegistryEntry[])entries);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            WAObjects.setUpRenders();
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Item[] items = new Item[]{angelPainting, angelArmItem};
        event.getRegistry().registerAll((IForgeRegistryEntry[])items);
    }

    @SideOnly(value=Side.CLIENT)
    private static void setUpRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityAngel.class, manager -> new RenderAngel(manager, (ModelBase)new ModelAngelEd()));
        RenderingRegistry.registerEntityRenderingHandler(EntityPainting2.class, manager -> new RenderAngelPainting(manager));
        ClientRegistry.bindTileEntitySpecialRenderer(TileSnowArm.class, (TileEntitySpecialRenderer)new RenderSnowArm());
    }

    private static Item createItem(Item item, String name) {
        item.setRegistryName("weeping-angels", name);
        item.func_77655_b(name);
        item.func_77637_a(CreativeTabs.field_78031_c);
        return item;
    }

    public static class WADamageSource
    extends DamageSource {
        private String message = "";

        public WADamageSource(String damageTypeIn) {
            super(damageTypeIn);
            this.message = damageTypeIn;
        }

        public ITextComponent func_151519_b(EntityLivingBase entity) {
            return new TextComponentString(entity.func_70005_c_() + " " + this.message);
        }
    }
}

