/*
 * Decompiled with CFR 0.152.
 */
package com.Mrbysco.CactusMod.tileentities;

import java.util.Random;
import net.minecraft.block.BlockHopper;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.VanillaInventoryCodeHooks;

public class TileEntityCactusHopper
extends TileEntityHopper {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private int transferCooldown = -1;
    private long tickedGameTime;
    private int ticksSinceDeleted;

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.field_190577_o : "container.cactus.hopper";
    }

    public int func_70302_i_() {
        return 5;
    }

    private boolean isInventoryEmpty() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_191420_l() {
        return this.isInventoryEmpty();
    }

    private boolean isFull() {
        for (ItemStack itemstack : this.inventory) {
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            int randInt;
            Random rand = this.field_145850_b.field_73012_v;
            --this.transferCooldown;
            ++this.ticksSinceDeleted;
            this.tickedGameTime = this.field_145850_b.func_82737_E();
            if (!this.isOnTransferCooldown()) {
                this.func_145896_c(0);
                this.func_145887_i();
            }
            if (!this.func_191420_l() && this.ticksSinceDeleted > 60 && this.inventory.get(randInt = rand.nextInt(this.func_70302_i_())) != ItemStack.field_190927_a) {
                ItemStack stack = (ItemStack)this.func_190576_q().get(randInt);
                int size = stack.func_190916_E();
                stack.func_190920_e(size - rand.nextInt(5));
                this.func_70299_a(randInt, stack);
                this.ticksSinceDeleted = 0;
                this.func_145887_i();
            }
        }
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.func_184281_d(null);
        this.func_190576_q().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.inventory;
    }

    public void func_145896_c(int ticks) {
        this.transferCooldown = ticks;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean func_174914_o() {
        return this.transferCooldown > 8;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.field_190577_o = compound.func_74779_i("CustomName");
        }
        this.transferCooldown = compound.func_74762_e("TransferCooldown");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        }
        compound.func_74768_a("TransferCooldown", this.transferCooldown);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.field_190577_o);
        }
        return compound;
    }

    private static ItemStack insertStack(IInventory source, IInventory destination, ItemStack stack, int index, EnumFacing direction) {
        ItemStack itemstack = destination.func_70301_a(index);
        if (TileEntityCactusHopper.canInsertItemInSlot(destination, stack, index, direction)) {
            boolean flag = false;
            boolean flag1 = destination.func_191420_l();
            if (itemstack.func_190926_b()) {
                destination.func_70299_a(index, stack);
                stack = ItemStack.field_190927_a;
                flag = true;
            } else if (TileEntityCactusHopper.canCombine(itemstack, stack)) {
                int i = stack.func_77976_d() - itemstack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190918_g(j);
                itemstack.func_190917_f(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                TileEntityCactusHopper tileCactusHopper1;
                if (flag1 && destination instanceof TileEntityCactusHopper && !(tileCactusHopper1 = (TileEntityCactusHopper)destination).func_174914_o()) {
                    int k = 0;
                    if (source != null && source instanceof TileEntityCactusHopper) {
                        TileEntityCactusHopper tileCactusHopper = (TileEntityCactusHopper)source;
                        if (tileCactusHopper1.tickedGameTime >= tileCactusHopper.tickedGameTime) {
                            k = 1;
                        }
                    }
                    tileCactusHopper1.func_145896_c(8 - k);
                }
                destination.func_70296_d();
            }
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        if (!inventoryIn.func_94041_b(index, stack)) {
            return false;
        }
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side);
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77960_j() != stack2.func_77960_j()) {
            return false;
        }
        if (stack1.func_190916_E() > stack1.func_77976_d()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    protected boolean func_145887_i() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.isOnTransferCooldown() && BlockHopper.func_149917_c((int)this.func_145832_p())) {
                boolean flag = false;
                if (!this.isInventoryEmpty()) {
                    flag = this.transferItemsOut();
                }
                if (!this.isFull()) {
                    boolean bl = flag = TileEntityCactusHopper.func_145891_a((IHopper)this) || flag;
                }
                if (flag) {
                    this.func_145896_c(8);
                    this.func_70296_d();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean transferItemsOut() {
        if (VanillaInventoryCodeHooks.insertHook((TileEntityHopper)this)) {
            return true;
        }
        IInventory iinventory = this.getInventoryForHopperTransfer();
        if (iinventory == null) {
            return false;
        }
        EnumFacing enumfacing = BlockHopper.func_176428_b((int)this.func_145832_p()).func_176734_d();
        if (this.isInventoryFull(iinventory, enumfacing)) {
            return false;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            ItemStack itemstack = this.func_70301_a(i).func_77946_l();
            ItemStack itemstack1 = TileEntityCactusHopper.func_174918_a((IInventory)this, (IInventory)iinventory, (ItemStack)this.func_70298_a(i, 1), (EnumFacing)enumfacing);
            if (itemstack1.func_190926_b()) {
                iinventory.func_70296_d();
                return true;
            }
            this.func_70299_a(i, itemstack);
        }
        return false;
    }

    private boolean isInventoryFull(IInventory inventoryIn, EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            for (int k : aint = isidedinventory.func_180463_a(side)) {
                ItemStack itemstack1 = isidedinventory.func_70301_a(k);
                if (!itemstack1.func_190926_b() && itemstack1.func_190916_E() == itemstack1.func_77976_d()) continue;
                return false;
            }
        } else {
            int i = inventoryIn.func_70302_i_();
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventoryIn.func_70301_a(j);
                if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    private IInventory getInventoryForHopperTransfer() {
        EnumFacing enumfacing = BlockHopper.func_176428_b((int)this.func_145832_p());
        return TileEntityCactusHopper.func_145893_b((World)this.func_145831_w(), (double)(this.func_96107_aA() + (double)enumfacing.func_82601_c()), (double)(this.func_96109_aB() + (double)enumfacing.func_96559_d()), (double)(this.func_96108_aC() + (double)enumfacing.func_82599_e()));
    }

    public long getLastUpdateTime() {
        return this.tickedGameTime;
    }
}

