/*
 * Decompiled with CFR 0.152.
 */
package com.Mrbysco.CactusMod.handlers;

import com.Mrbysco.CactusMod.blocks.BlockCarvedCactus;
import com.Mrbysco.CactusMod.entities.EntityCactusGolem;
import com.Mrbysco.CactusMod.entities.EntityCactusSnowman;
import com.Mrbysco.CactusMod.init.CactusBlocks;
import com.google.common.base.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.pattern.BlockMaterialMatcher;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class CactusBlockHandler {
    private static BlockPattern cactusGolemPattern;
    private static BlockPattern cactusSnowmanPattern;

    @SubscribeEvent
    public void CactusPlacementCheck(BlockEvent.PlaceEvent event) {
        Block block;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (!world.field_72995_K && (block = world.func_180495_p(pos).func_177230_c()) instanceof BlockCarvedCactus) {
            CactusBlockHandler.spawnGolem(world, pos, block);
        }
    }

    @SubscribeEvent
    public void CactusBenchCraft(PlayerEvent.ItemCraftedEvent event) {
        IInventory craftmatrix = event.craftMatrix;
        TextComponentTranslation cactusText = new TextComponentTranslation("cactus.workbench.name", new Object[0]);
        if (craftmatrix.func_145748_c_() == cactusText) {
            EntityPlayer player = event.player;
            if (event.player.field_70170_p.field_73012_v.nextInt(10) < 4 && player.field_70170_p.field_72995_K) {
                player.func_70097_a(DamageSource.field_76367_g, 1.0f);
            }
        }
    }

    public static void spawnGolem(World worldIn, BlockPos pos, Block block) {
        block11: {
            BlockPattern.PatternHelper cactusPatternHelper;
            block10: {
                cactusPatternHelper = CactusBlockHandler.getCactusGolemPattern(block).func_177681_a(worldIn, pos);
                if (cactusPatternHelper == null) break block10;
                for (int j = 0; j < CactusBlockHandler.getCactusGolemPattern(block).func_177684_c(); ++j) {
                    for (int k = 0; k < CactusBlockHandler.getCactusGolemPattern(block).func_177685_b(); ++k) {
                        worldIn.func_180501_a(cactusPatternHelper.func_177670_a(j, k, 0).func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
                BlockPos blockpos = cactusPatternHelper.func_177670_a(1, 2, 0).func_177508_d();
                EntityCactusGolem cactusGolem = new EntityCactusGolem(worldIn);
                cactusGolem.func_70849_f(true);
                cactusGolem.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.05, (double)blockpos.func_177952_p() + 0.5, 0.0f, 0.0f);
                worldIn.func_72838_d((Entity)cactusGolem);
                for (EntityPlayerMP entityplayermp1 : worldIn.func_72872_a(EntityPlayerMP.class, cactusGolem.func_174813_aQ().func_186662_g(5.0))) {
                    CriteriaTriggers.field_192133_m.func_192229_a(entityplayermp1, (Entity)cactusGolem);
                }
                for (int j1 = 0; j1 < 120; ++j1) {
                    worldIn.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)blockpos.func_177958_n() + worldIn.field_73012_v.nextDouble(), (double)blockpos.func_177956_o() + worldIn.field_73012_v.nextDouble() * 3.9, (double)blockpos.func_177952_p() + worldIn.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                }
                for (int k1 = 0; k1 < CactusBlockHandler.getCactusGolemPattern(block).func_177684_c(); ++k1) {
                    for (int l1 = 0; l1 < CactusBlockHandler.getCactusGolemPattern(block).func_177685_b(); ++l1) {
                        BlockWorldState blockworldstate1 = cactusPatternHelper.func_177670_a(k1, l1, 0);
                        worldIn.func_175722_b(blockworldstate1.func_177508_d(), Blocks.field_150350_a, false);
                    }
                }
                break block11;
            }
            cactusPatternHelper = CactusBlockHandler.getCactusSnowmanPattern(block).func_177681_a(worldIn, pos);
            if (cactusPatternHelper == null) break block11;
            for (int i = 0; i < CactusBlockHandler.getCactusSnowmanPattern(block).func_177685_b(); ++i) {
                BlockWorldState blockworldstate = cactusPatternHelper.func_177670_a(0, i, 0);
                worldIn.func_180501_a(blockworldstate.func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
            }
            EntityCactusSnowman cactiMan = new EntityCactusSnowman(worldIn);
            BlockPos blockpos1 = cactusPatternHelper.func_177670_a(0, 2, 0).func_177508_d();
            cactiMan.func_70012_b((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.05, (double)blockpos1.func_177952_p() + 0.5, 0.0f, 0.0f);
            worldIn.func_72838_d((Entity)cactiMan);
            for (EntityPlayerMP entityplayermp : worldIn.func_72872_a(EntityPlayerMP.class, cactiMan.func_174813_aQ().func_186662_g(5.0))) {
                CriteriaTriggers.field_192133_m.func_192229_a(entityplayermp, (Entity)cactiMan);
            }
            for (int l = 0; l < 120; ++l) {
                worldIn.func_175688_a(EnumParticleTypes.SNOW_SHOVEL, (double)blockpos1.func_177958_n() + worldIn.field_73012_v.nextDouble(), (double)blockpos1.func_177956_o() + worldIn.field_73012_v.nextDouble() * 2.5, (double)blockpos1.func_177952_p() + worldIn.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
            }
            for (int i1 = 0; i1 < CactusBlockHandler.getCactusSnowmanPattern(block).func_177685_b(); ++i1) {
                BlockWorldState blockworldstate2 = cactusPatternHelper.func_177670_a(0, i1, 0);
                worldIn.func_175722_b(blockworldstate2.func_177508_d(), Blocks.field_150350_a, false);
            }
        }
    }

    public static BlockPattern getCactusGolemPattern(Block block) {
        if (cactusGolemPattern == null) {
            if (block == CactusBlocks.carved_cactus) {
                cactusGolemPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"~^~", "###", "~#~"}).func_177662_a('^', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)CactusBlocks.carved_cactus))).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)CactusBlocks.prickly_iron))).func_177662_a('~', BlockWorldState.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
            } else if (block == CactusBlocks.jacko_cactus) {
                cactusGolemPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"~^~", "###", "~#~"}).func_177662_a('^', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)CactusBlocks.jacko_cactus))).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)CactusBlocks.prickly_iron))).func_177662_a('~', BlockWorldState.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177661_b();
            }
        }
        return cactusGolemPattern;
    }

    public static BlockPattern getCactusSnowmanPattern(Block block) {
        if (cactusSnowmanPattern == null) {
            if (block == CactusBlocks.carved_cactus) {
                cactusSnowmanPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"^", "#", "#"}).func_177662_a('^', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)CactusBlocks.carved_cactus))).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150433_aE))).func_177661_b();
            } else if (block == CactusBlocks.jacko_cactus) {
                cactusSnowmanPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"^", "#", "#"}).func_177662_a('^', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)CactusBlocks.jacko_cactus))).func_177662_a('#', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_150433_aE))).func_177661_b();
            }
        }
        return cactusSnowmanPattern;
    }
}

