/*
 * Decompiled with CFR 0.152.
 */
package com.Mrbysco.CactusMod.blocks.redstone;

import com.Mrbysco.CactusMod.entities.EntityActualSpike;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class BlockCactusDispenser
extends Block {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static final PropertyBool TRIGGERED = PropertyBool.func_177716_a((String)"triggered");
    protected Random rand = new Random();
    private int shotTimer;

    public BlockCactusDispenser(String registryName) {
        super(Material.field_151570_A);
        this.func_149711_c(0.4f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)));
        this.func_149663_c("cactusmod:" + registryName.replaceAll("_", ""));
        this.setRegistryName(registryName);
    }

    public int func_149738_a(World worldIn) {
        return 4;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.setDefaultDirection(worldIn, pos, state);
    }

    private void setDefaultDirection(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            boolean flag = worldIn.func_180495_p(pos.func_177978_c()).func_185913_b();
            boolean flag1 = worldIn.func_180495_p(pos.func_177968_d()).func_185913_b();
            if (enumfacing == EnumFacing.NORTH && flag && !flag1) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && flag1 && !flag) {
                enumfacing = EnumFacing.NORTH;
            } else {
                boolean flag2 = worldIn.func_180495_p(pos.func_177976_e()).func_185913_b();
                boolean flag3 = worldIn.func_180495_p(pos.func_177974_f()).func_185913_b();
                if (enumfacing == EnumFacing.WEST && flag2 && !flag3) {
                    enumfacing = EnumFacing.EAST;
                } else if (enumfacing == EnumFacing.EAST && flag3 && !flag2) {
                    enumfacing = EnumFacing.WEST;
                }
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)), 2);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(pos.func_177984_a());
        boolean flag1 = (Boolean)state.func_177229_b((IProperty)TRIGGERED);
        if (flag && !flag1) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!flag && flag1) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            ++this.shotTimer;
            System.out.println(this.shotTimer);
            if (this.shotTimer >= 4) {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                double d0 = (double)pos.func_177958_n() + 0.7 * (double)facing.func_82601_c();
                double d1 = (double)pos.func_177956_o() + 0.7 * (double)facing.func_96559_d();
                double d2 = (double)pos.func_177952_p() + 0.7 * (double)facing.func_82599_e();
                EntityActualSpike spike = new EntityActualSpike(worldIn, d0, d1 + 0.5, d2);
                spike.setDamage(0.5);
                switch (facing) {
                    default: 
                }
                spike.field_70165_t = d0 + 0.5;
                spike.field_70163_u = d1 + 0.5;
                spike.field_70161_v = d2 + 0.5;
                spike.func_70186_c(facing.func_82601_c(), (float)facing.func_96559_d() + 0.1f, facing.func_82599_e(), 1.1f, 6.0f);
                spike.setKnockbackStrength(2);
                worldIn.func_72838_d((Entity)spike);
                this.shotTimer = 0;
            }
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)TRIGGERED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TRIGGERED});
    }

    public void func_190948_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"cactus.dispenser.info"));
    }
}

