/*
 * Decompiled with CFR 0.152.
 */
package com.Mrbysco.CactusMod.blocks;

import com.Mrbysco.CactusMod.CactusMod;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCactusPunji
extends Block {
    protected static final AxisAlignedBB PUNJI_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public BlockCactusPunji(String registryName) {
        super(Material.field_151570_A);
        this.func_149711_c(0.25f);
        this.func_149647_a(CactusMod.cactustab);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149663_c("cactusmod:" + registryName.replaceAll("_", ""));
        this.setRegistryName(registryName);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PUNJI_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos);
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        return !worldIn.func_175623_d(pos.func_177977_b());
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkForDrop(worldIn, pos, state);
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return false;
        }
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
        if (entityIn instanceof EntityLiving) {
            entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
        } else if (entityIn instanceof EntityItem) {
            EntityItem item = (EntityItem)entityIn;
            if (item.field_70173_aa >= 2400) {
                entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
            }
        }
    }

    public void func_190948_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"cactus.carpet.info"));
        tooltip.add(TextFormatting.GREEN + I18n.func_74838_a((String)"cactus.carpet.info2"));
    }
}

