/*
 * Decompiled with CFR 0.152.
 */
package com.Mrbysco.CactusMod;

import com.Mrbysco.CactusMod.config.CactusConfig;
import com.Mrbysco.CactusMod.entities.EntityCactusCow;
import com.Mrbysco.CactusMod.entities.EntityCactusCreeper;
import com.Mrbysco.CactusMod.handlers.CactusBlockHandler;
import com.Mrbysco.CactusMod.handlers.CactusMobHandler;
import com.Mrbysco.CactusMod.handlers.CactusToolHandler;
import com.Mrbysco.CactusMod.init.CactusEntities;
import com.Mrbysco.CactusMod.init.CactusTab;
import com.Mrbysco.CactusMod.proxy.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="cactusmod", name="The Cactus Mod", version="1.1.0", acceptedMinecraftVersions="[1.12]")
public class CactusMod {
    @Mod.Instance(value="cactusmod")
    public static CactusMod instance;
    @SidedProxy(clientSide="com.Mrbysco.CactusMod.proxy.ClientProxy", serverSide="com.Mrbysco.CactusMod.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static CactusTab cactustab;
    public static final Logger logger;
    public static final Item.ToolMaterial cactusTool;
    public static final ItemArmor.ArmorMaterial cactusArmor;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger.debug("Registering Config");
        MinecraftForge.EVENT_BUS.register((Object)new CactusConfig());
        logger.debug("Register Entities");
        CactusEntities.register();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (Biome biome : Biome.field_185377_q) {
            if (biome != Biomes.field_76769_d && biome != Biomes.field_76786_s && biome != Biomes.field_185442_R && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) continue;
            if (CactusConfig.general.cowSpawn) {
                logger.debug("Registering Cactus Cow spawn");
                biome.func_76747_a(EnumCreatureType.CREATURE).add(new Biome.SpawnListEntry(EntityCactusCow.class, 8, 4, 4));
            }
            if (!CactusConfig.general.creeperSpawn) continue;
            logger.debug("Registering Cactus Creeper spawn");
            biome.func_76747_a(EnumCreatureType.MONSTER).add(new Biome.SpawnListEntry(EntityCactusCreeper.class, 100, 4, 4));
        }
        logger.debug("Registering Handlers");
        MinecraftForge.EVENT_BUS.register((Object)new CactusBlockHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CactusToolHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CactusMobHandler());
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        cactustab = new CactusTab();
        logger = LogManager.getLogger((String)"cactusmod");
        cactusTool = EnumHelper.addToolMaterial((String)"cactus", (int)0, (int)67, (float)3.0f, (float)0.2f, (int)15).setRepairItem(new ItemStack((Block)Blocks.field_150434_aF));
        cactusArmor = EnumHelper.addArmorMaterial((String)"cactus", (String)"cactusmod:cactus", (int)0, (int[])new int[]{0, 0, 0, 0}, (int)15, (SoundEvent)SoundEvents.field_187719_p, (float)0.0f).setRepairItem(new ItemStack((Block)Blocks.field_150434_aF));
    }
}

