/*
 * Decompiled with CFR 0.152.
 */
package quaternary.breadcrumbtrail;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Util {
    public static boolean getItemNBTBoolean(ItemStack stack, String key, boolean def) {
        Util.verifyTag(stack);
        if (!Util.hasKey(stack, key)) {
            return def;
        }
        return stack.func_77978_p().func_74767_n(key);
    }

    public static void setItemNBTBoolean(ItemStack stack, String key, boolean val) {
        Util.verifyTag(stack);
        stack.func_77978_p().func_74757_a(key, val);
    }

    public static int getItemNBTInt(ItemStack stack, String key, int def) {
        Util.verifyTag(stack);
        if (!Util.hasKey(stack, key)) {
            return def;
        }
        return stack.func_77978_p().func_74762_e(key);
    }

    public static void setItemNBTInt(ItemStack stack, String key, int val) {
        Util.verifyTag(stack);
        stack.func_77978_p().func_74768_a(key, val);
    }

    public static BlockPos getItemNBTBlockPos(ItemStack stack, String key, BlockPos def) {
        Util.verifyTag(stack);
        if (!Util.hasKey(stack, key)) {
            return def;
        }
        NBTTagCompound posTag = stack.func_77978_p().func_74775_l(key);
        return NBTUtil.func_186861_c((NBTTagCompound)posTag);
    }

    public static void setItemNBTBlockPos(ItemStack stack, String key, BlockPos val) {
        Util.verifyTag(stack);
        stack.func_77978_p().func_74782_a(key, (NBTBase)NBTUtil.func_186859_a((BlockPos)val));
    }

    static void verifyTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    static boolean hasKey(ItemStack stack, String key) {
        return stack.func_77978_p().func_74764_b(key);
    }

    @SideOnly(value=Side.CLIENT)
    public static String vagueCrumbCount(int crumbs) {
        if (crumbs < 0) {
            return I18n.func_74838_a((String)"breadcrumbtrail.crumbcount.hahawhat").replace('&', '\u00a7');
        }
        if (crumbs == 0) {
            return I18n.func_74838_a((String)"breadcrumbtrail.crumbcount.zero");
        }
        if (crumbs == 1) {
            return I18n.func_74838_a((String)"breadcrumbtrail.crumbcount.one");
        }
        if (crumbs <= 4) {
            return I18n.func_74837_a((String)"breadcrumbtrail.crumbcount.exactplural", (Object[])new Object[]{crumbs});
        }
        String qualifier = crumbs <= 10 ? "few" : (crumbs <= 25 ? "handful" : (crumbs <= 40 ? "couple" : (crumbs <= 100 ? "fair" : (crumbs <= 150 ? "sizable" : (crumbs <= 300 ? "lot" : "ton")))));
        return I18n.func_74838_a((String)("breadcrumbtrail.crumbcount." + qualifier));
    }

    public static String italicise(String in) {
        return TextFormatting.ITALIC + in + TextFormatting.RESET;
    }
}

