/*
 * Decompiled with CFR 0.152.
 */
package quaternary.breadcrumbtrail;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.breadcrumbtrail.BlockBreadcrumb;
import quaternary.breadcrumbtrail.BreadcrumbTrail;
import quaternary.breadcrumbtrail.Util;

public class ItemBreadcrumbPouch
extends Item {
    public static final int MAX_CRUMBS = 512;
    @GameRegistry.ObjectHolder(value="breadcrumbtrail:breadcrumb")
    public static final Block BREADCRUMB_BLOCK = Blocks.field_150484_ah;
    @GameRegistry.ItemStackHolder(value="breadcrumbtrail:breadcrumb_pouch")
    public static final ItemStack pouchStack = ItemStack.field_190927_a;
    public static final String OPEN_KEY = "OpenBag";
    public static final String CRUMB_KEY = "Crumbs";
    public static final String POS_KEY = "LastCrumbPosition";

    public ItemBreadcrumbPouch() {
        this.setRegistryName(new ResourceLocation("breadcrumbtrail", "breadcrumb_pouch"));
        this.func_77655_b("breadcrumbtrail.breadcrumb_pouch");
        this.func_77637_a(BreadcrumbTrail.TAB);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("breadcrumbtrail", "open"), (stack, world, living) -> ItemBreadcrumbPouch.isOpen(stack) ? 1.0f : 0.0f);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldStack;
        boolean isOpen = ItemBreadcrumbPouch.isOpen(heldStack = player.func_184586_b(hand));
        ItemBreadcrumbPouch.setOpen(heldStack, !isOpen);
        ItemBreadcrumbPouch.setLastPosition(heldStack, player.func_180425_c());
        return new ActionResult(EnumActionResult.SUCCESS, (Object)heldStack);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer player) {
        ItemBreadcrumbPouch.setLastPosition(stack, player.func_180425_c());
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        int distSquared;
        if (world.field_72995_K || !ItemBreadcrumbPouch.isOpen(stack) || ItemBreadcrumbPouch.getCrumbs(stack) == 0 || !(entity instanceof EntityPlayer)) {
            return;
        }
        BlockPos entPos = entity.func_180425_c();
        BlockPos lastCrumbPos = ItemBreadcrumbPouch.getLastPosition(stack);
        int dx = entPos.func_177958_n() - lastCrumbPos.func_177958_n();
        int dz = entPos.func_177952_p() - lastCrumbPos.func_177952_p();
        if ((distSquared = (dx *= dx) + (dz *= dz)) >= 81) {
            if (world.func_180495_p(entPos).func_177230_c() instanceof BlockBreadcrumb) {
                return;
            }
            if (!world.func_180495_p(entPos).func_177230_c().func_176200_f((IBlockAccess)world, entPos)) {
                return;
            }
            if (!BREADCRUMB_BLOCK.func_176196_c(world, entPos)) {
                return;
            }
            ItemBreadcrumbPouch.setCrumbs(stack, ItemBreadcrumbPouch.getCrumbs(stack) - 1);
            ItemBreadcrumbPouch.setLastPosition(stack, entPos);
            world.func_180501_a(entPos, BREADCRUMB_BLOCK.func_176223_P(), 3);
            world.func_184133_a(null, entPos, SoundEvents.field_187902_gb, SoundCategory.BLOCKS, 0.7f, 2.0f);
            ((EntityPlayer)entity).func_71064_a(BreadcrumbTrail.LEAVE_BREADCRUMB_STAT, 1);
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == BreadcrumbTrail.TAB) {
            for (boolean open : new boolean[]{false, true}) {
                for (int crumbs : new int[]{0, 256, 512}) {
                    ItemStack stack = pouchStack.func_77946_l();
                    ItemBreadcrumbPouch.setOpen(stack, open);
                    ItemBreadcrumbPouch.setCrumbs(stack, crumbs);
                    items.add((Object)stack);
                }
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)ItemBreadcrumbPouch.getCrumbs(stack) / 512.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        if (this.getDurabilityForDisplay(stack) >= 0.9) {
            return 0xEE4422;
        }
        return 8671022;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        String vagueCount = Util.vagueCrumbCount(ItemBreadcrumbPouch.getCrumbs(stack));
        tooltip.add(vagueCount);
        tooltip.add(I18n.func_74838_a((String)(ItemBreadcrumbPouch.isOpen(stack) ? "breadcrumbtrail.open" : "breadcrumbtrail.closed")));
        if (ItemBreadcrumbPouch.getCrumbs(stack) == 0) {
            tooltip.add("");
            String useBtnString = Minecraft.func_71410_x().field_71474_y.field_74313_G.getDisplayName();
            tooltip.add(Util.italicise(I18n.func_74837_a((String)"breadcrumbtrail.breadcrumb_pouch.hint1", (Object[])new Object[]{useBtnString})));
            tooltip.add(Util.italicise(I18n.func_74838_a((String)"breadcrumbtrail.breadcrumb_pouch.hint2")));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public static boolean isOpen(ItemStack stack) {
        return Util.getItemNBTBoolean(stack, OPEN_KEY, false);
    }

    public static void setOpen(ItemStack stack, boolean open) {
        Util.setItemNBTBoolean(stack, OPEN_KEY, open);
    }

    public static int getCrumbs(ItemStack stack) {
        return Util.getItemNBTInt(stack, CRUMB_KEY, 0);
    }

    public static void setCrumbs(ItemStack stack, int crumbs) {
        Util.setItemNBTInt(stack, CRUMB_KEY, crumbs);
    }

    public static BlockPos getLastPosition(ItemStack stack) {
        return Util.getItemNBTBlockPos(stack, POS_KEY, new BlockPos(0, 0, 0));
    }

    public static void setLastPosition(ItemStack stack, BlockPos pos) {
        Util.setItemNBTBlockPos(stack, POS_KEY, pos);
    }
}

