/*
 * Decompiled with CFR 0.152.
 */
package quaternary.breadcrumbtrail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import quaternary.breadcrumbtrail.BlockBreadcrumb;

public class EntityAIEatBreadcrumb
extends EntityAIBase {
    EntityLiving breadEater;
    World world;
    List<BlockPos> cacheNearbyCrumbs;
    int crumbCheckTimer = 0;
    int eatCrumbTimer = 0;
    boolean immediatelyRetryFlag = false;
    SoundEvent eatSound = SoundEvents.field_187537_bA;
    int chance = 30;

    public EntityAIEatBreadcrumb(EntityLiving breadEater, @Nullable SoundEvent eatSound, int chance) {
        this.breadEater = breadEater;
        this.world = breadEater.field_70170_p;
        if (eatSound != null) {
            this.eatSound = eatSound;
        }
        this.chance = chance;
    }

    public boolean func_75250_a() {
        if (this.immediatelyRetryFlag || this.breadEater.func_70681_au().nextInt(this.chance) == 0) {
            this.cacheNearbyCrumbs = this.findNearbyCrumbs(this.breadEater.func_180425_c());
            this.immediatelyRetryFlag = false;
            return !this.cacheNearbyCrumbs.isEmpty();
        }
        return false;
    }

    public void func_75249_e() {
        if (this.cacheNearbyCrumbs.isEmpty()) {
            return;
        }
        this.breadEater.func_70661_as().func_75499_g();
        BlockPos p = this.cacheNearbyCrumbs.get(0);
        this.breadEater.func_70661_as().func_75492_a((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), this.breadEater.func_70605_aq().func_75638_b());
        this.crumbCheckTimer = 200;
    }

    public boolean func_75253_b() {
        return this.crumbCheckTimer > 0 || this.eatCrumbTimer > 0;
    }

    public void func_75246_d() {
        if (!this.world.func_82736_K().func_82766_b("mobGriefing")) {
            return;
        }
        BlockPos crumbPos = this.breadEater.func_180425_c();
        if (this.crumbCheckTimer > 0) {
            --this.crumbCheckTimer;
            if (this.crumbCheckTimer % 3 == 0 && this.isCrumb(this.world.func_180495_p(crumbPos))) {
                this.eatCrumbTimer = this.world.field_73012_v.nextInt(5) + 7;
                this.crumbCheckTimer = 0;
                this.breadEater.func_70661_as().func_75499_g();
            }
            return;
        }
        if (this.eatCrumbTimer > 0) {
            --this.eatCrumbTimer;
        }
        if (this.eatCrumbTimer == 0 && this.isCrumb(this.world.func_180495_p(crumbPos))) {
            this.world.func_175655_b(crumbPos, false);
            this.world.func_184133_a(null, crumbPos, this.eatSound, this.breadEater.func_184176_by(), 0.4f, 1.0f);
            this.crumbCheckTimer = 0;
            this.immediatelyRetryFlag = true;
        }
    }

    private boolean isCrumb(IBlockState state) {
        return state.func_177230_c() instanceof BlockBreadcrumb;
    }

    private List<BlockPos> findNearbyCrumbs(BlockPos myPosition) {
        Iterable allPositions = BlockPos.func_177975_b((BlockPos)myPosition.func_177982_a(-10, -5, -10), (BlockPos)myPosition.func_177982_a(10, 5, 10));
        ArrayList<BlockPos> breadPos = new ArrayList<BlockPos>();
        for (BlockPos.MutableBlockPos p : allPositions) {
            if (!(this.world.func_180495_p((BlockPos)p).func_177230_c() instanceof BlockBreadcrumb)) continue;
            breadPos.add(p.func_185334_h());
        }
        Collections.shuffle(breadPos);
        return breadPos;
    }
}

