/*
 * Decompiled with CFR 0.152.
 */
package quaternary.breadcrumbtrail;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatBasic;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import quaternary.breadcrumbtrail.BlockBreadcrumb;
import quaternary.breadcrumbtrail.EntityAIEatBreadcrumb;
import quaternary.breadcrumbtrail.ItemBreadcrumbPouch;
import quaternary.breadcrumbtrail.RecipeFillPouch;

@Mod(modid="breadcrumbtrail", name="Breadcrumb Trail", version="1.0.0", acceptedMinecraftVersions="[1.12.2]")
public class BreadcrumbTrail {
    public static final String MODID = "breadcrumbtrail";
    public static final String NAME = "Breadcrumb Trail";
    public static final String VERSION = "1.0.0";
    public static List<Block> BLOCKS;
    public static List<Item> ITEMS;
    @GameRegistry.ItemStackHolder(value="breadcrumbtrail:breadcrumb_pouch")
    public static final ItemStack tabStack;
    public static final CreativeTabs TAB;
    public static final StatBase LEAVE_BREADCRUMB_STAT;
    @GameRegistry.ObjectHolder(value="breadcrumbtrail:breadcrumb")
    public static final Item BREADCRUMB_ITEM;

    @Mod.EventHandler
    public static void postinit(FMLPostInitializationEvent e) {
        Set parrotTameItems = (Set)ReflectionHelper.getPrivateValue(EntityParrot.class, null, (String[])new String[]{"TAME_ITEMS", "field_192016_bJ"});
        parrotTameItems.add(BREADCRUMB_ITEM);
    }

    static {
        tabStack = ItemStack.field_190927_a;
        TAB = new CreativeTabs(MODID){

            public ItemStack func_78016_d() {
                return tabStack;
            }
        };
        LEAVE_BREADCRUMB_STAT = new StatBasic("stat.breadcrumbtrail.leavecrumb", (ITextComponent)new TextComponentTranslation("stat.breadcrumbtrail.leavecrumb", new Object[0])).func_75966_h().func_75971_g();
        BLOCKS = new ArrayList<Block>();
        BLOCKS.add(new BlockBreadcrumb());
        ITEMS = new ArrayList<Item>();
        for (Block b : BLOCKS) {
            ItemBlock ib = new ItemBlock(b);
            ib.setRegistryName(b.getRegistryName());
            ITEMS.add((Item)ib);
        }
        ITEMS.add(new ItemBreadcrumbPouch());
        BREADCRUMB_ITEM = Items.field_190931_a;
    }

    @Mod.EventBusSubscriber(modid="breadcrumbtrail", value={Side.CLIENT})
    public static class ClientEventHandler {
        @SubscribeEvent
        public static void models(ModelRegistryEvent e) {
            for (Item i : ITEMS) {
                ModelResourceLocation mrl = new ModelResourceLocation(i.getRegistryName(), "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)i, (int)0, (ModelResourceLocation)mrl);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="breadcrumbtrail")
    public static class EventHandler {
        @SubscribeEvent
        public static void blocks(RegistryEvent.Register<Block> e) {
            IForgeRegistry reg = e.getRegistry();
            reg.registerAll((IForgeRegistryEntry[])BLOCKS.toArray(new Block[0]));
        }

        @SubscribeEvent
        public static void items(RegistryEvent.Register<Item> e) {
            IForgeRegistry reg = e.getRegistry();
            reg.registerAll((IForgeRegistryEntry[])ITEMS.toArray(new Item[0]));
        }

        @SubscribeEvent
        public static void recipes(RegistryEvent.Register<IRecipe> e) {
            IForgeRegistry reg = e.getRegistry();
            reg.register((IForgeRegistryEntry)new RecipeFillPouch());
        }

        @SubscribeEvent
        public static void joinWorld(EntityJoinWorldEvent evt) {
            Entity ent = evt.getEntity();
            if (ent instanceof EntityLiving) {
                EntityLiving living = (EntityLiving)ent;
                if (living instanceof EntityParrot) {
                    ((EntityParrot)living).field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIEatBreadcrumb(living, SoundEvents.field_192797_eu, 20));
                } else if (living instanceof EntityOcelot) {
                    ((EntityOcelot)living).field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIEatBreadcrumb(living, null, 50));
                } else if (living instanceof EntityWolf) {
                    ((EntityWolf)living).field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIEatBreadcrumb(living, SoundEvents.field_187857_gE, 40));
                } else if (living instanceof EntityRabbit) {
                    ((EntityRabbit)living).field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIEatBreadcrumb(living, null, 30));
                }
            }
        }
    }
}

