/*
 * Decompiled with CFR 0.152.
 */
package quaternary.breadcrumbtrail;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.breadcrumbtrail.BreadcrumbTrail;

public class BlockBreadcrumb
extends Block {
    @SideOnly(value=Side.CLIENT)
    static Random rand;
    public static final AxisAlignedBB AABB;

    public BlockBreadcrumb() {
        super(Material.field_151594_q, MapColor.field_151676_q);
        this.setRegistryName(new ResourceLocation("breadcrumbtrail", "breadcrumb"));
        this.func_149663_c("breadcrumbtrail.breadcrumb");
        this.func_149647_a(BreadcrumbTrail.TAB);
        this.func_149711_c(0.05f);
        this.func_149752_b(0.05f);
        this.func_149672_a(SoundType.field_185856_i);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        IBlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof BlockBreadcrumb)) {
            return false;
        }
        if (rand == null) {
            rand = new Random();
        }
        for (int i = 0; i < 3; ++i) {
            double x = rand.nextDouble() + (double)pos.func_177958_n();
            double y = 0.05 + (double)pos.func_177956_o();
            double z = rand.nextDouble() + (double)pos.func_177952_p();
            double dx = (rand.nextDouble() - 0.5) / 10.0;
            double dy = 0.01;
            double dz = (rand.nextDouble() - 0.5) / 10.0;
            manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), x, y, z, dx, dy, dz, new int[]{Block.func_149682_b((Block)state.func_177230_c())});
        }
        return true;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.canStay(world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canStay(world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    private boolean canStay(World world, BlockPos pos) {
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        Block downBlock = downState.func_177230_c();
        Material thisMaterial = world.func_180495_p(pos).func_185904_a();
        return downBlock.canPlaceTorchOnTop(downState, (IBlockAccess)world, pos.func_177977_b()) && !thisMaterial.func_76224_d();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    static {
        AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    }
}

