/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.pocketblocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import us.drullk.pocketblocks.IModelRegisterCallback;

public class ItemPersonalBeacon
extends Item
implements IModelRegisterCallback {
    private static final String NBT_BEACON_LEVELS = "Levels";
    private static final String NBT_POTION_ARRAY = "CustomPotionEffects";
    private static final String NBT_POTION_EFFECT = "Id";
    private static final String NBT_POTION_COUNTDOWN = "Duration";
    private static final String NBT_POTION_INTENSITY = "Amplifier";
    private static final String LANG_INVALID = "personalbeacon.invalid";
    private static final String LANG_VALID = "personalbeacon.valid";

    public ItemPersonalBeacon() {
        this.func_185043_a(new ResourceLocation("active"), (stack, worldIn, entityIn) -> {
            NBTTagCompound compound = stack.func_77978_p();
            return compound != null ? (compound.func_74762_e(NBT_BEACON_LEVELS) > 0 ? 1.0f : 0.0f) : 0.0f;
        });
    }

    public void func_77663_a(ItemStack personalBeacon, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagCompound compoundTest;
        if (worldIn.field_72995_K || !(entityIn instanceof EntityPlayer) || entityIn instanceof FakePlayer || entityIn.func_130014_f_().func_82737_E() % 80L != 0L) {
            return;
        }
        boolean isValid = false;
        int levels = 0;
        EntityPlayer player = (EntityPlayer)entityIn;
        NonNullList playerInventory = player.field_71071_by.field_70462_a;
        if (itemSlot > 8 && itemSlot % 9 != 0 && itemSlot % 9 != 8) {
            isValid = true;
            itemSlot -= 9;
            int maxSize = playerInventory.size();
            for (int row = 1; isValid && row < maxSize / 9; ++row) {
                int minSlot = itemSlot + 8 * row;
                int maxSlot = itemSlot + 10 * row;
                int requiredRow = row + itemSlot / 9;
                isValid = minSlot / 9 == requiredRow && maxSlot / 9 == requiredRow && maxSlot < maxSize && ItemPersonalBeacon.scanInventoryRow(minSlot, maxSlot, (List<ItemStack>)playerInventory);
                if (!isValid) continue;
                ++levels;
            }
            isValid = levels > 0;
        }
        NBTTagCompound compound = (compoundTest = personalBeacon.func_77978_p()) == null ? new NBTTagCompound() : compoundTest;
        compound.func_74768_a(NBT_BEACON_LEVELS, levels);
        if (!isValid) {
            return;
        }
        itemSlot += 9;
        NBTTagList beaconEffects = compound.func_150295_c(NBT_POTION_ARRAY, 10);
        if (beaconEffects.func_82582_d()) {
            ItemStack leftStack = (ItemStack)playerInventory.get(itemSlot - 1);
            ItemStack rightStack = (ItemStack)playerInventory.get(itemSlot + 1);
            if (!leftStack.func_190926_b() && !rightStack.func_190926_b()) {
                Item rightItem = rightStack.func_77973_b();
                Item leftItem = leftStack.func_77973_b();
                if (leftItem.isBeaconPayment(leftStack)) {
                    if (!(rightItem instanceof ItemPotion)) {
                        return;
                    }
                    ItemPersonalBeacon.handleActivation(rightStack, leftStack, compound);
                } else if (rightItem.isBeaconPayment(rightStack)) {
                    if (!(leftItem instanceof ItemPotion)) {
                        return;
                    }
                    ItemPersonalBeacon.handleActivation(leftStack, rightStack, compound);
                }
                personalBeacon.func_77982_d(compound);
            }
        } else {
            RegistryNamespaced potionRegistry = Potion.field_188414_b;
            boolean allCountsZero = true;
            boolean allTagsInvalid = true;
            NBTTagList modifiedEffects = new NBTTagList();
            for (NBTBase beaconEffect : beaconEffects) {
                int duration;
                if (!(beaconEffect instanceof NBTTagCompound)) continue;
                allTagsInvalid = false;
                NBTTagCompound effectNBT = (NBTTagCompound)beaconEffect;
                int timeLeft = effectNBT.func_74762_e(NBT_POTION_COUNTDOWN);
                if (timeLeft == 0) continue;
                Potion effect = Potion.func_188412_a((int)effectNBT.func_74762_e(NBT_POTION_EFFECT));
                if (timeLeft > 80) {
                    duration = Math.min(280, timeLeft);
                    effectNBT.func_74768_a(NBT_POTION_COUNTDOWN, timeLeft - 80);
                } else {
                    duration = timeLeft;
                    effectNBT.func_74768_a(NBT_POTION_COUNTDOWN, 0);
                    effectNBT.func_74768_a(NBT_POTION_EFFECT, 0);
                }
                if (timeLeft > 0) {
                    allCountsZero = false;
                }
                if (effect == null) continue;
                int range = levels * 2;
                AxisAlignedBB box = player.func_174813_aQ().func_186662_g((double)range);
                List players = player.func_130014_f_().func_72872_a(EntityPlayer.class, box);
                for (EntityPlayer aPlayer : players) {
                    aPlayer.func_70690_d(new PotionEffect(effect, duration, effectNBT.func_74762_e(NBT_POTION_INTENSITY)));
                }
                modifiedEffects.func_74742_a((NBTBase)effectNBT);
            }
            compound.func_74782_a(NBT_POTION_ARRAY, (NBTBase)(allTagsInvalid || allCountsZero ? new NBTTagList() : modifiedEffects));
            personalBeacon.func_77982_d(compound);
        }
    }

    private static void handleActivation(ItemStack potionStack, ItemStack paymentStack, NBTTagCompound compound) {
        List effects = PotionUtils.func_185189_a((ItemStack)potionStack);
        NBTTagList effectList = new NBTTagList();
        for (PotionEffect effect : effects) {
            NBTTagCompound effectCompound = new NBTTagCompound();
            int potionID = Potion.func_188409_a((Potion)effect.func_188419_a());
            if (potionID == 0) continue;
            effectCompound.func_74768_a(NBT_POTION_EFFECT, potionID);
            effectCompound.func_74768_a(NBT_POTION_COUNTDOWN, effect.func_76459_b());
            effectCompound.func_74768_a(NBT_POTION_INTENSITY, effect.func_76458_c());
            effectList.func_74742_a((NBTBase)effectCompound);
        }
        potionStack.func_190918_g(1);
        paymentStack.func_190918_g(1);
        compound.func_74782_a(NBT_POTION_ARRAY, (NBTBase)effectList);
    }

    private static boolean scanInventoryRow(int startSlot, int endSlot, List<ItemStack> inventory) {
        boolean bool = true;
        for (int counter = startSlot; bool && counter < inventory.size() + 9 && counter <= endSlot; ++counter) {
            int c = counter + 9 < inventory.size() ? counter + 9 : counter - 27;
            ItemStack stack = inventory.get(c);
            if (stack.func_190926_b()) {
                return false;
            }
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            BlockPos dummyPos = BlockPos.field_177992_a.func_177977_b();
            bool = block.isBeaconBase(null, dummyPos, dummyPos);
        }
        return bool;
    }

    @Override
    public void registerModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            int levels = compound.func_74762_e(NBT_BEACON_LEVELS);
            if (levels > 0) {
                tooltip.add(I18n.func_74837_a((String)LANG_VALID, (Object[])new Object[]{levels, 2 * levels}));
            } else {
                tooltip.add(I18n.func_74838_a((String)LANG_INVALID));
            }
        } else if (worldIn != null) {
            // empty if block
        }
        PotionUtils.func_185182_a((ItemStack)stack, tooltip, (float)1.0f);
    }

    static int getPrimaryColorFromStack(ItemStack stack) {
        int returned = -16777216;
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            return returned;
        }
        NBTTagList list = compound.func_150295_c(NBT_POTION_ARRAY, 10);
        if (list.func_74745_c() < 1) {
            return returned;
        }
        NBTBase potionCompound = list.func_179238_g(0);
        if (!(potionCompound instanceof NBTTagCompound)) {
            return returned;
        }
        Potion potion = Potion.func_188412_a((int)((NBTTagCompound)potionCompound).func_74762_e(NBT_POTION_EFFECT));
        if (potion == null) {
            return returned;
        }
        return potion.func_76401_j();
    }
}

