/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.transistor.functions;

import com.google.common.collect.Multimap;
import com.latmod.transistor.TransistorData;
import com.latmod.transistor.TransistorFunction;
import com.latmod.transistor.functions.TransistorFunctions;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class FunctionCrash
extends TransistorFunction {
    private static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    private static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    public FunctionCrash(int index, String n, int m, TextFormatting c) {
        super(index, n, m, c);
    }

    @Override
    public String getEffect(TransistorFunction upgrade) {
        if (upgrade == TransistorFunctions.PURGE) {
            return "transistor.effect.poison";
        }
        if (upgrade == TransistorFunctions.VOID) {
            return "transistor.effect.wither_weakness";
        }
        if (upgrade == TransistorFunctions.SPARK) {
            return "transistor.effect.damage";
        }
        if (upgrade == TransistorFunctions.PING) {
            return "transistor.effect.speed";
        }
        return "";
    }

    @Override
    public void onPassiveUpdate(TransistorData data, EntityPlayer player, boolean isSelected) {
        if (data.getTick(player.field_70170_p) % 20L == 0L) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 20, 0, true, false));
            player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 20, 0, true, false));
        }
    }

    @Override
    public boolean onAttack(TransistorData data, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean hitEntity(TransistorData data, EntityPlayer player, EntityLivingBase target) {
        data.useEnergy(player.field_70170_p, 100);
        if (data.hasUpgrade(TransistorFunctions.PURGE)) {
            target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100));
        }
        if (data.hasUpgrade(TransistorFunctions.VOID)) {
            target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 100));
            target.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100));
        }
        int xp = 7;
        if (data.hasUpgrade(TransistorFunctions.SPARK)) {
            xp *= 2;
        }
        if (data.hasUpgrade(TransistorFunctions.PING)) {
            xp = (int)((double)xp * 0.6);
        }
        data.addXP(player.field_70170_p, xp);
        return true;
    }

    @Override
    public void getAttributeModifiers(TransistorData data, Multimap<String, AttributeModifier> map) {
        if (!data.canUseEnergy(100)) {
            return;
        }
        double damage = 7.0;
        double speed = 2.4;
        if (data.hasUpgrade(TransistorFunctions.SPARK)) {
            damage *= 2.0;
            speed *= 0.6;
        }
        if (data.hasUpgrade(TransistorFunctions.PING)) {
            damage *= 0.6;
            speed *= 2.0;
        }
        map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "Weapon modifier", damage, 0));
        map.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(ATTACK_SPEED_MODIFIER, "Weapon modifier", speed, 0));
    }

    @Override
    public boolean canHarvestBlock(TransistorData data, IBlockState state) {
        return data.canUseEnergy(100);
    }

    @Override
    public float getBlockDestroySpeed(TransistorData data, IBlockState state) {
        if (!data.canUseEnergy(100)) {
            return 0.0f;
        }
        float speed = 6.0f;
        if (data.hasUpgrade(TransistorFunctions.SPARK)) {
            speed *= 2.0f;
        }
        if (data.hasUpgrade(TransistorFunctions.PING)) {
            speed *= 2.0f;
        }
        return speed;
    }

    @Override
    public void onBlockDestroyed(TransistorData data, IBlockState state, BlockPos pos, EntityPlayer player) {
        data.useEnergy(player.field_70170_p, 100);
        data.addXP(player.field_70170_p, 1);
    }
}

