/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.transistor.client;

import com.latmod.transistor.TransistorData;
import com.latmod.transistor.TransistorFunction;
import com.latmod.transistor.client.GuiTransistor;
import com.latmod.transistor.client.Widget;
import com.latmod.transistor.net.MessageSelectFunction;
import com.latmod.transistor.net.TransistorNetHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiSelectFunction
extends GuiScreen {
    private final TransistorData data;
    private final EnumHand hand;
    private final List<Button> buttons;
    private final long openedAt;
    private double modifier;

    public GuiSelectFunction(TransistorData d, EnumHand h) {
        this.data = d;
        this.hand = h;
        this.buttons = new ArrayList<Button>();
        this.openedAt = Minecraft.func_71386_F();
        this.buttons.add(new ButtonConfig());
        for (int i = 0; i < 4; ++i) {
            ButtonFunction b = new ButtonFunction(i);
            if (b.function.isEmpty()) continue;
            this.buttons.add(b);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.modifier = Math.min((double)(Minecraft.func_71386_F() - this.openedAt) / 250.0, 1.0);
        this.modifier *= this.modifier;
        int cx = this.field_146294_l / 2;
        int cy = this.field_146295_m / 2;
        for (int i = 0; i < this.buttons.size(); ++i) {
            double d = (double)i * Math.PI * 2.0 / (double)this.buttons.size() - Math.PI * (1.0 - this.modifier + 1.0) / 2.0;
            this.buttons.get((int)i).x = cx + (int)(Math.cos(d) * 60.0 * this.modifier - 16.0);
            this.buttons.get((int)i).y = cy + (int)(Math.sin(d) * 60.0 * this.modifier - 16.0);
        }
        for (Button button : this.buttons) {
            button.draw(mouseX, mouseY);
        }
        if (this.modifier >= 1.0) {
            for (Button button : this.buttons) {
                if (!button.mouseOver(mouseX, mouseY)) continue;
                ArrayList<String> text = new ArrayList<String>();
                button.addHoverText(text);
                GuiUtils.drawHoveringText(text, (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)this.field_146294_l, (FontRenderer)this.field_146289_q);
            }
        }
    }

    protected void func_146286_b(int x, int y, int mouseButton) {
        super.func_146286_b(x, y, mouseButton);
        this.field_146297_k.func_147108_a(null);
        if (this.field_146297_k.field_71462_r == null) {
            this.field_146297_k.func_71381_h();
        }
        if (this.modifier >= 1.0) {
            for (Button button : this.buttons) {
                if (!button.mouseOver(x, y)) continue;
                button.click();
                return;
            }
        }
    }

    private class ButtonConfig
    extends Button {
        private ButtonConfig() {
        }

        @Override
        public void click() {
            GuiSelectFunction.this.field_146297_k.func_147108_a((GuiScreen)new GuiTransistor(GuiSelectFunction.this.hand));
        }

        @Override
        public void addHoverText(List<String> text) {
            text.add(I18n.func_135052_a((String)"transistor.configure", (Object[])new Object[0]));
        }

        @Override
        public void draw(int mouseX, int mouseY) {
            super.draw(mouseX, mouseY);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.x, (float)this.y, (float)0.0f);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            RenderHelper.func_74520_c();
            GlStateManager.func_179091_B();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179126_j();
            GuiSelectFunction.this.field_146296_j.func_184391_a((EntityLivingBase)GuiSelectFunction.this.field_146297_k.field_71439_g, GuiSelectFunction.this.field_146297_k.field_71439_g.func_184586_b(GuiSelectFunction.this.hand), 0, 0);
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
        }
    }

    private class ButtonFunction
    extends Button {
        private final int index;
        private final TransistorFunction function;

        private ButtonFunction(int i) {
            this.index = i;
            this.function = GuiSelectFunction.this.data.getAttack(this.index);
        }

        @Override
        public void click() {
            GuiSelectFunction.this.data.setSelected(this.index);
            TransistorNetHandler.NET.sendToServer((IMessage)new MessageSelectFunction(this.index, GuiSelectFunction.this.hand));
        }

        @Override
        public void addHoverText(List<String> text) {
            text.add(this.function.getDisplayName());
        }

        @Override
        public void draw(int mouseX, int mouseY) {
            super.draw(mouseX, mouseY);
            Gui.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.w), (int)(this.y + this.h), (int)-1439485133);
            if (GuiSelectFunction.this.data.getSelected() == this.index) {
                Gui.func_73734_a((int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.w + 1), (int)(this.y + this.h + 1), (int)-150783);
            }
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179098_w();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiSelectFunction.this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            Widget.addSpriteToBuffer(buffer, this.x, this.y, this.w, this.h, this.function.sprite);
            tessellator.func_78381_a();
            if (this.mouseOver(mouseX, mouseY) && (double)(Minecraft.func_71386_F() - GuiSelectFunction.this.openedAt) / 250.0 >= 1.0) {
                Gui.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.w), (int)(this.y + this.h), (int)0x33FFFFFF);
            }
        }
    }

    public static class Button {
        public int x;
        public int y;
        public int w = 32;
        public int h = 32;

        public void click() {
        }

        public void addHoverText(List<String> text) {
        }

        public void draw(int mouseX, int mouseY) {
            Gui.func_73734_a((int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.w + 1), (int)(this.y + this.h + 1), (int)(this.mouseOver(mouseX, mouseY) ? -1426063361 : 0x33FFFFFF));
            Gui.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.w), (int)(this.y + this.h), (int)-16777216);
        }

        public boolean mouseOver(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseX <= this.x + this.w && mouseY >= this.y && mouseY <= this.y + this.h;
        }
    }
}

