/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.transistor.client;

import com.latmod.transistor.TransistorFunction;
import com.latmod.transistor.client.ButtonFunctionBase;
import com.latmod.transistor.client.ButtonShape;
import com.latmod.transistor.client.GuiTransistor;
import com.latmod.transistor.net.MessageUnlockSlot;
import com.latmod.transistor.net.TransistorNetHandler;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ButtonUpgrade
extends ButtonFunctionBase {
    private final int attack;
    private final int slot;

    public ButtonUpgrade(GuiTransistor g, int x, int y, int a, int s) {
        super(g, x, y, ButtonShape.SMALL);
        this.attack = a;
        this.slot = s;
    }

    @Override
    public int getIndex() {
        return 4 + this.attack * 2 + this.slot;
    }

    @Override
    public void click(boolean left) {
        if (left && this.isLocked() && this.gui.data.getPoints() >= 1) {
            this.gui.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((result, id) -> {
                this.gui.field_146297_k.func_147108_a((GuiScreen)this.gui);
                if (result && this.gui.data.unlockSlot(this.getIndex(), true)) {
                    TransistorNetHandler.NET.sendToServer((IMessage)new MessageUnlockSlot(this.getIndex(), this.gui.hand));
                }
            }, I18n.func_135052_a((String)"transistor.unlock_upgrade_slot_q", (Object[])new Object[0]), "", 0));
        } else {
            super.click(left);
        }
    }

    @Override
    public void addHoverText(List<String> text) {
        TransistorFunction function;
        if (!this.getFunction().isEmpty()) {
            text.add(this.getFunction().getDisplayName());
        }
        if (this.isLocked()) {
            text.add(TextFormatting.GOLD + I18n.func_135052_a((String)"transistor.locked", (Object[])new Object[0]));
            if (this.gui.data.getPoints() >= 1) {
                text.add(TextFormatting.GRAY + I18n.func_135052_a((String)"transistor.unlock_upgrade_slot", (Object[])new Object[0]));
            }
        } else if (!this.getFunction().isEmpty()) {
            text.add(TextFormatting.GRAY + I18n.func_135052_a((String)"transistor.uninstall_function", (Object[])new Object[0]));
        }
        if ((function = this.getFunction()).isEmpty() && this.gui.selectedFunction != null && !this.gui.data.getAttack(this.attack).isEmpty()) {
            function = this.gui.selectedFunction.function;
        }
        if (!function.isEmpty()) {
            String s = this.gui.data.getAttack(this.attack).getEffect(function);
            if (s.isEmpty()) {
                text.add(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"transistor.effect.none", (Object[])new Object[0]));
            } else {
                text.add(I18n.func_135052_a((String)"transistor.effects", (Object[])new Object[0]) + ":");
                text.add(TextFormatting.BLUE + "+ " + I18n.func_135052_a((String)s, (Object[])new Object[0]));
            }
        }
    }

    @Override
    public boolean isLocked() {
        return !this.gui.data.isUpgradeSlotUnlocked(this.attack, this.slot);
    }
}

