/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.transistor.client;

import com.latmod.transistor.TransistorFunction;
import com.latmod.transistor.client.BorderType;
import com.latmod.transistor.client.ButtonShape;
import com.latmod.transistor.client.GuiTransistor;
import com.latmod.transistor.client.Widget;
import com.latmod.transistor.net.MessageInstallFunction;
import com.latmod.transistor.net.MessageUninstallFunction;
import com.latmod.transistor.net.TransistorNetHandler;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class ButtonFunctionBase
extends Widget {
    public ButtonFunctionBase(GuiTransistor g, int _x, int _y, ButtonShape s) {
        super(g, _x, _y, s);
    }

    public TransistorFunction getFunction() {
        return this.gui.data.getFunction(this.getIndex());
    }

    public abstract int getIndex();

    @Override
    public void click(boolean left) {
        if (this.getFunction().isEmpty()) {
            byte func;
            int index;
            if (left && this.gui.selectedFunction != null && this.gui.data.installFunction(index = this.getIndex(), func = this.gui.selectedFunction.function.index)) {
                TransistorNetHandler.NET.sendToServer((IMessage)new MessageInstallFunction(index, func, this.gui.hand));
                this.gui.selectedFunction = null;
            }
        } else if (!left) {
            this.gui.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((result, id) -> {
                this.gui.field_146297_k.func_147108_a((GuiScreen)this.gui);
                if (result && this.gui.data.uninstallFunction(this.getIndex())) {
                    TransistorNetHandler.NET.sendToServer((IMessage)new MessageUninstallFunction(this.getIndex(), this.gui.hand));
                }
            }, I18n.func_135052_a((String)"transistor.uninstall_function_q", (Object[])new Object[0]), "", 0));
        }
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        this.gui.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        ButtonFunctionBase.addModalRectToBuffer(buffer, this.x + 1, this.y + 1, this.shape.iu, this.shape.iv, this.shape.w - 2, this.shape.h - 2);
        tessellator.func_78381_a();
        if (!this.getFunction().isEmpty()) {
            this.gui.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            ButtonFunctionBase.addSpriteToBuffer(buffer, this.x + 1, this.y + 1, this.shape.w - 2, this.shape.h - 2, this.getFunction().sprite);
            tessellator.func_78381_a();
        }
        if (this.isLocked()) {
            this.gui.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            ButtonFunctionBase.addModalRectToBuffer(buffer, this.x + 1, this.y + 1, this.shape.iu, this.shape.iv, this.shape.w - 2, this.shape.h - 2);
            tessellator.func_78381_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            ButtonFunctionBase.addModalRectToBuffer(buffer, this.x + (this.shape.w - 10) / 2, this.y + (this.shape.h - 14) / 2, 312, 33, 10, 14);
            tessellator.func_78381_a();
        }
        BorderType type = BorderType.NONE;
        if (this.isSelected()) {
            type = BorderType.SELECTED;
        } else if (this.mouseOver(mouseX, mouseY) && !this.getFunction().isEmpty()) {
            type = BorderType.MOUSE_OVER;
        } else if (this.hasError()) {
            type = BorderType.ERROR;
        } else if (this.isBeingUsed()) {
            type = BorderType.USED;
        }
        this.gui.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        ButtonFunctionBase.addModalRectToBuffer(buffer, this.x, this.y, type.u, this.shape.v, this.shape.w, this.shape.h);
        tessellator.func_78381_a();
        super.draw(mouseX, mouseY);
    }

    @Override
    public boolean isSelected() {
        return this.gui.selectedFunction != null && !this.gui.selectedFunction.hasError() && !this.isLocked() && this.getFunction().isEmpty();
    }

    public boolean isLocked() {
        return false;
    }
}

