/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.transistor.client;

import com.latmod.transistor.TransistorFunction;
import com.latmod.transistor.client.ButtonFunctionBase;
import com.latmod.transistor.client.ButtonShape;
import com.latmod.transistor.client.GuiTransistor;
import com.latmod.transistor.functions.TransistorFunctions;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class ButtonFunction
extends ButtonFunctionBase {
    public final TransistorFunction function;

    public ButtonFunction(GuiTransistor g, int x, int y, int i) {
        super(g, x, y, ButtonShape.LARGE);
        this.function = TransistorFunctions.get(i);
    }

    @Override
    public TransistorFunction getFunction() {
        return this.function;
    }

    @Override
    public int getIndex() {
        return -this.function.index;
    }

    @Override
    public void addHoverText(List<String> text) {
        text.add(this.getFunction().getDisplayName());
        if (this.isLocked()) {
            text.add(TextFormatting.GOLD + I18n.func_135052_a((String)"transistor.locked", (Object[])new Object[0]));
        } else {
            int used = this.gui.data.isFunctionInUse(this.function);
            if (used >= 0) {
                String s = used < 4 ? I18n.func_135052_a((String)"transistor.in_use.attack", (Object[])new Object[]{used + 1}) : (used < 12 ? I18n.func_135052_a((String)"transistor.in_use.upgrade", (Object[])new Object[]{(used - 4) % 2 + 1, (used - 4) / 2 + 1}) : I18n.func_135052_a((String)"transistor.in_use.passive", (Object[])new Object[]{used - 12 + 1}));
                text.add(I18n.func_135052_a((String)"transistor.in_use", (Object[])new Object[]{s}));
            } else {
                text.add(TextFormatting.GRAY + I18n.func_135052_a((String)"transistor.install_function", (Object[])new Object[0]));
            }
        }
        text.add(TextFormatting.GRAY + I18n.func_135052_a((String)"transistor.memory", (Object[])new Object[0]) + ": " + TextFormatting.GOLD + this.function.memory);
    }

    @Override
    public boolean isLocked() {
        return !this.gui.data.isFunctionUnlocked(this.function);
    }

    @Override
    public boolean isBeingUsed() {
        return this.gui.data.isFunctionInUse(this.function) >= 0;
    }

    @Override
    public boolean isSelected() {
        return this.gui.selectedFunction == this && !this.hasError();
    }

    @Override
    public boolean hasError() {
        return this.gui.selectedFunction == this && this.gui.data.getUsedMemory() + this.function.memory > this.gui.data.getMemory() || this.gui.data.isOverloaded(this.function);
    }

    @Override
    public void click(boolean left) {
        if (left) {
            if (this.gui.selectedFunction == this) {
                this.gui.selectedFunction = null;
            } else if (!this.isBeingUsed() && !this.isLocked()) {
                this.gui.selectedFunction = this;
            }
        }
    }
}

