/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.transistor.client;

import com.latmod.transistor.client.BorderType;
import com.latmod.transistor.client.ButtonShape;
import com.latmod.transistor.client.GuiTransistor;
import com.latmod.transistor.client.Widget;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class Bar
extends Widget {
    public static final int CYAN = 0;
    public static final int GREEN = 1;
    public static final int YELLOW = 2;
    public static final int ORANGE = 3;
    public static final int RED = 4;

    public Bar(GuiTransistor g, int _x, int _y) {
        super(g, _x, _y, ButtonShape.BAR);
    }

    public int getValue() {
        return 0;
    }

    public int getMaxValue() {
        return 100;
    }

    public boolean isLocked() {
        return false;
    }

    public int getBars(int actualBars) {
        return actualBars;
    }

    public int getBarColor(int index, int bars, int actualBars) {
        return 0;
    }

    @Override
    public void addHoverText(List<String> text) {
        if (this.isLocked()) {
            text.add(TextFormatting.GOLD + I18n.func_135052_a((String)"transistor.locked", (Object[])new Object[0]));
        }
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        this.gui.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Bar.addModalRectToBuffer(buffer, this.x + 1, this.y + 1, this.shape.iu, this.shape.iv, this.shape.w - 2, this.shape.h - 2);
        tessellator.func_78381_a();
        int actualBars = MathHelper.func_76143_f((double)((double)this.getValue() * 15.0 / (double)this.getMaxValue()));
        int bars = this.getBars(actualBars);
        if (bars > 0) {
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            int b = MathHelper.func_76125_a((int)bars, (int)0, (int)15);
            for (int i = 0; i <= b; ++i) {
                Bar.addModalRectToBuffer(buffer, this.x + 1, this.y + 2 + (15 - i) * 3, 307, 51 + this.getBarColor(i, bars, actualBars) * 3, 11, 2);
            }
            tessellator.func_78381_a();
        }
        if (this.isLocked()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            Bar.addModalRectToBuffer(buffer, this.x + 1, this.y + 1, this.shape.iu, this.shape.iv, this.shape.w - 2, this.shape.h - 2);
            tessellator.func_78381_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Bar.addModalRectToBuffer(buffer, this.x + (this.shape.w - 10) / 2, this.y + (this.shape.h - 14) / 2, 312, 33, 10, 14);
        }
        BorderType type = BorderType.NONE;
        if (this.hasError()) {
            type = BorderType.ERROR;
        } else if (this.isBeingUsed()) {
            type = BorderType.USED;
        }
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Bar.addModalRectToBuffer(buffer, this.x, this.y, type.u, this.shape.v, this.shape.w, this.shape.h);
        tessellator.func_78381_a();
    }
}

