/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.transistor;

import com.latmod.transistor.TransistorFunction;
import com.latmod.transistor.functions.TransistorFunctions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TransistorData
implements ICapabilityProvider {
    @CapabilityInject(value=TransistorData.class)
    public static Capability<TransistorData> CAP;
    public static final String[] KEYS;
    public final ItemStack stack;
    private long created = -1L;
    private int energy = -1;
    private byte memory = (byte)-1;
    private byte selected = (byte)-1;
    private int xp = -1;
    private int points = -1;
    private Integer unlocked = null;
    private byte cachedMemoryUsage = (byte)-1;
    private final TransistorFunction[] functions = new TransistorFunction[16];
    private final Map<String, Object> customTempData = new HashMap<String, Object>();

    public static TransistorData get(ItemStack stack) {
        return (TransistorData)stack.getCapability(CAP, null);
    }

    public TransistorData(ItemStack is) {
        this.stack = is;
    }

    private NBTTagCompound getNBT() {
        NBTTagCompound nbt = this.stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            this.stack.func_77982_d(nbt);
        }
        return nbt;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CAP;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CAP ? this : null);
    }

    public long getTimeCreated() {
        if (this.created == -1L) {
            this.created = this.getNBT().func_74764_b("Created") ? this.getNBT().func_74763_f("Created") : -1L;
        }
        return this.created;
    }

    public void setTimeCreated(long value) {
        if (this.getTimeCreated() != value) {
            this.created = value;
            this.getNBT().func_74772_a("Created", this.created);
        }
    }

    public long getTick(World world) {
        long l = world.func_82737_E() - this.getTimeCreated();
        if (l < 0L) {
            l = 0L;
            this.setTimeCreated(world.func_82737_E());
        }
        return l;
    }

    public int getEnergy() {
        if (this.energy < 0) {
            this.energy = this.getNBT().func_74762_e("Energy");
        }
        return this.energy;
    }

    public void setEnergy(int value) {
        if (this.getEnergy() != value) {
            this.energy = value;
            this.getNBT().func_74768_a("Energy", this.energy);
        }
    }

    public int getMaxEnergy() {
        return this.getMemory() * 1000;
    }

    public int getMemory() {
        if (this.memory < 0) {
            this.memory = this.getNBT().func_74771_c("Memory");
        }
        return this.memory;
    }

    public void setMemory(byte value) {
        if (this.getMemory() != value) {
            this.memory = value;
            this.getNBT().func_74768_a("Memory", (int)this.memory);
        }
    }

    public byte getSelected() {
        if (this.selected < 0) {
            this.selected = this.getNBT().func_74771_c("Selected");
        }
        return this.selected;
    }

    public boolean setSelected(int value) {
        byte v = (byte)MathHelper.func_76125_a((int)value, (int)0, (int)3);
        if (this.getSelected() != v) {
            this.selected = v;
            this.getNBT().func_74774_a("Selected", this.selected);
            this.customTempData.clear();
            return true;
        }
        return false;
    }

    public int getXP() {
        if (this.xp < 0) {
            this.xp = this.getNBT().func_74762_e("XP");
        }
        return this.xp;
    }

    public void setXP(int value) {
        if (this.getXP() != value) {
            this.xp = value;
            this.getNBT().func_74768_a("XP", this.xp);
        }
    }

    public void addXP(World world, int xp) {
        this.setXP(this.getXP() + xp);
    }

    public int getNextLevelXP() {
        return 100;
    }

    public int getPoints() {
        if (this.points < 0) {
            this.points = this.getNBT().func_74762_e("Points");
        }
        return this.points;
    }

    public void setPoints(int value) {
        if (this.getPoints() != value) {
            this.points = value;
            this.getNBT().func_74768_a("Points", this.points);
        }
    }

    public int getUnlocked() {
        if (this.unlocked == null) {
            this.unlocked = this.getNBT().func_74762_e("Unlocked");
            NBTTagList list = this.getNBT().func_150295_c("Available", 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                TransistorFunction function = TransistorFunctions.get(list.func_150307_f(i));
                if (function.isEmpty()) continue;
                this.unlocked = this.unlocked | 1 << function.index;
            }
        }
        return this.unlocked;
    }

    public void setUnlocked(int value) {
        if (this.getUnlocked() != value) {
            this.unlocked = value;
            this.getNBT().func_74768_a("Unlocked", this.unlocked.intValue());
        }
    }

    public boolean isFunctionUnlocked(TransistorFunction function) {
        return !function.isEmpty() && (this.getUnlocked() & 1 << function.index) != 0;
    }

    public boolean isSlotUnlocked(int index) {
        return index < 4 || (this.getUnlocked() & 1 << index + 12) != 0;
    }

    public int isFunctionInUse(TransistorFunction function) {
        if (!this.isFunctionUnlocked(function)) {
            return -1;
        }
        for (int i = 0; i < 16; ++i) {
            if (!this.getFunction(i).equals(function)) continue;
            return i;
        }
        return -1;
    }

    public void unlockFunction(TransistorFunction function) {
        if (!function.isEmpty()) {
            this.setUnlocked(this.getUnlocked() | 1 << function.index);
        }
    }

    public boolean unlockSlot(int index, boolean points) {
        if (index < 4 || this.isSlotUnlocked(index)) {
            return false;
        }
        if (points) {
            int p = 1;
            if (index >= 12) {
                p = 2;
            }
            if (this.getPoints() >= p) {
                this.setPoints(this.getPoints() - p);
            } else {
                return false;
            }
        }
        this.setUnlocked(this.getUnlocked() | 1 << index + 12);
        return true;
    }

    public boolean isOverloaded(TransistorFunction function) {
        return false;
    }

    public TransistorFunction getFunction(int index) {
        if (index < 0 || index >= 16) {
            return TransistorFunctions.EMPTY;
        }
        if (this.functions[index] == null) {
            TransistorFunction function = this.getNBT().func_150297_b(KEYS[index], 99) ? TransistorFunctions.get(this.getNBT().func_74771_c(KEYS[index])) : TransistorFunctions.get(this.getNBT().func_74779_i(KEYS[index]));
            this.functions[index] = this.isFunctionUnlocked(function) ? function : TransistorFunctions.EMPTY;
        }
        return this.functions[index];
    }

    public void setFunction(int index, TransistorFunction function) {
        if (index < 0 || index >= 16) {
            return;
        }
        if (!this.getFunction(index).equals(function)) {
            this.functions[index] = function;
            this.cachedMemoryUsage = (byte)-1;
            if (!function.isEmpty()) {
                this.getNBT().func_74774_a(KEYS[index], function.index);
            } else {
                this.getNBT().func_82580_o(KEYS[index]);
            }
        }
    }

    public TransistorFunction getAttack(int index) {
        return index < 0 || index >= 4 ? TransistorFunctions.EMPTY : this.getFunction(index);
    }

    public void setAttack(int index, TransistorFunction function) {
        if (index >= 0 && index < 4) {
            this.setFunction(index, function);
        }
    }

    public TransistorFunction getSelectedAttack() {
        return this.getAttack(this.getSelected());
    }

    public TransistorFunction getUpgrade(int attack, int slot) {
        return attack < 0 || attack >= 4 || slot < 0 || slot >= 2 ? TransistorFunctions.EMPTY : this.getFunction(4 + attack * 2 + slot);
    }

    public void setUpgrade(int attack, int slot, TransistorFunction function) {
        if (attack >= 0 && attack < 4 && slot >= 0 && slot < 2) {
            this.setFunction(4 + attack * 2 + slot, function);
        }
    }

    public boolean hasUpgrade(TransistorFunction function) {
        for (int i = 0; i < 2; ++i) {
            if (!this.getUpgrade(this.getSelected(), i).equals(function)) continue;
            return true;
        }
        return false;
    }

    public boolean isUpgradeSlotUnlocked(int attack, int slot) {
        return attack >= 0 && attack < 4 && slot >= 0 && slot < 2 && this.isSlotUnlocked(attack * 2 + slot + 4);
    }

    public void unlockUpgradeSlot(int attack, int slot) {
        if (attack >= 0 && attack < 4 && slot >= 0 && slot < 2) {
            this.setUnlocked(this.getUnlocked() | 1 << attack * 2 + slot + 16);
        }
    }

    public TransistorFunction getPassive(int index) {
        return index < 0 || index >= 4 ? TransistorFunctions.EMPTY : this.getFunction(index + 12);
    }

    public void setPassive(int index, TransistorFunction function) {
        if (index >= 0 && index < 4) {
            this.setFunction(index + 12, function);
        }
    }

    public boolean hasPassive(TransistorFunction function) {
        for (int i = 0; i < 4; ++i) {
            if (!this.getPassive(i).equals(function)) continue;
            return true;
        }
        return false;
    }

    public boolean isPassiveSlotUnlocked(int index) {
        return index >= 0 && index < 4 && this.isSlotUnlocked(index + 12);
    }

    public void unlockPassiveSlot(int index) {
        if (index >= 0 && index < 4) {
            this.setUnlocked(this.getUnlocked() | 1 << index + 24);
        }
    }

    public void setCustomTempData(String key, @Nullable Object object) {
        if (object == null) {
            this.customTempData.remove(key);
        } else {
            this.customTempData.put(key, object);
        }
    }

    @Nullable
    public <E> E getCustomTempData(String key) {
        return (E)this.customTempData.get(key);
    }

    public void update(EntityPlayer player, boolean isSelected) {
        if (this.getTimeCreated() == -1L) {
            this.setTimeCreated(player.field_70170_p.func_82737_E());
        }
        this.getSelectedAttack().onUpdate(this, player, isSelected);
        for (int i = 0; i < 4; ++i) {
            this.getPassive(i).onPassiveUpdate(this, player, isSelected);
        }
        if (this.getTick(player.field_70170_p) % 200L == 199L) {
            this.setEnergy(Math.min(this.getMaxEnergy(), this.getEnergy() + 1000));
        }
    }

    public void selectNext() {
        int s;
        int o = s = this.getSelected();
        while ((s = (s + 1) % 4) != o && this.getAttack(s).isEmpty()) {
        }
        this.setSelected(s);
    }

    public byte getUsedMemory() {
        if (this.cachedMemoryUsage >= 0) {
            return this.cachedMemoryUsage;
        }
        this.cachedMemoryUsage = 0;
        for (int i = 0; i < 16; ++i) {
            TransistorFunction function = this.getFunction(i);
            if (function.isEmpty()) continue;
            this.cachedMemoryUsage = (byte)(this.cachedMemoryUsage + function.memory);
        }
        return this.cachedMemoryUsage;
    }

    public boolean installFunction(int index, int f) {
        if (index < 0 || index >= 16 || !this.getFunction(index).isEmpty() || !this.isSlotUnlocked(index)) {
            return false;
        }
        TransistorFunction function = TransistorFunctions.get(f);
        if (!function.isEmpty() && this.isFunctionUnlocked(function) && this.getUsedMemory() + function.memory <= this.getMemory()) {
            if (index >= 4 && index < 12 && this.getAttack((index - 4) / 2).isEmpty()) {
                return false;
            }
            this.setFunction(index, function);
            return true;
        }
        return false;
    }

    public boolean uninstallFunction(int index) {
        if (index < 0 || index >= 16 || this.getFunction(index).isEmpty()) {
            return false;
        }
        if (index < 4) {
            this.setFunction(index * 2 + 4, TransistorFunctions.EMPTY);
            this.setFunction(index * 2 + 5, TransistorFunctions.EMPTY);
        }
        this.setFunction(index, TransistorFunctions.EMPTY);
        return true;
    }

    public boolean installMemory() {
        return false;
    }

    public boolean canUseEnergy(int energy) {
        return this.getEnergy() > 0;
    }

    public boolean useEnergy(World world, int energy) {
        if (this.canUseEnergy(energy)) {
            this.setEnergy(Math.max(0, this.getEnergy() - energy));
            return true;
        }
        return false;
    }

    static {
        KEYS = new String[16];
        for (int i = 0; i < 4; ++i) {
            TransistorData.KEYS[i] = "Attack_" + (i + 1);
            for (int j = 0; j < 2; ++j) {
                TransistorData.KEYS[i * 2 + 4 + j] = "Upgrade_" + (i + 1) + "_" + (j + 1);
            }
            TransistorData.KEYS[i + 12] = "Passive_" + (i + 1);
        }
    }
}

