/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.transistor;

import com.google.common.collect.Multimap;
import com.latmod.transistor.Transistor;
import com.latmod.transistor.TransistorData;
import com.latmod.transistor.TransistorFunction;
import com.latmod.transistor.functions.TransistorFunctions;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTransistor
extends Item {
    public ItemTransistor(String id) {
        this.setRegistryName("transistor", id);
        this.func_77655_b("transistor." + id);
        this.func_77637_a(CreativeTabs.field_78037_j);
        this.func_77625_d(1);
        this.func_77664_n();
        this.func_185043_a(new ResourceLocation("mode"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                TransistorData data = TransistorData.get(stack);
                int energy = data.getEnergy();
                if (energy <= 0) {
                    return 1.0f;
                }
                double e = (double)energy / (double)data.getMaxEnergy();
                if (e < 0.1) {
                    return Minecraft.func_71386_F() % 800L >= 400L ? 0.5f : 0.0f;
                }
                return e < 1.0 ? 0.5f : 0.0f;
            }
        });
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new TransistorData(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            Transistor.PROXY.openGui(TransistorData.get(player.func_184586_b(hand)), hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public boolean onEntitySwing(EntityLivingBase entity, ItemStack stack) {
        if (entity instanceof EntityPlayer) {
            TransistorData data = TransistorData.get(stack);
            return data.getSelectedAttack().onAttack(data, (EntityPlayer)entity);
        }
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer) {
            TransistorData data = TransistorData.get(stack);
            return data.getSelectedAttack().hitEntity(data, (EntityPlayer)attacker, target);
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof EntityPlayer) {
            TransistorData data = TransistorData.get(stack);
            data.update((EntityPlayer)entity, isSelected);
        }
    }

    public int getEntityLifespan(ItemStack stack, World world) {
        return Integer.MAX_VALUE;
    }

    public boolean onEntityItemUpdate(EntityItem entity) {
        entity.func_184224_h(true);
        return false;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        TransistorData data = TransistorData.get(stack);
        return data.getSelectedAttack().canHarvestBlock(data, state);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        TransistorData data = TransistorData.get(stack);
        return data.getSelectedAttack().getBlockDestroySpeed(data, state);
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            TransistorData data = TransistorData.get(stack);
            data.getSelectedAttack().onBlockDestroyed(data, state, pos, (EntityPlayer)entity);
        }
        return true;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap map = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            TransistorData data = TransistorData.get(stack);
            data.getSelectedAttack().getAttributeModifiers(data, (Multimap<String, AttributeModifier>)map);
        }
        return map;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            TransistorData data = TransistorData.get(new ItemStack((Item)this));
            data.setMemory((byte)16);
            data.unlockFunction(TransistorFunctions.CRASH);
            data.setAttack(0, TransistorFunctions.CRASH);
            data.setEnergy(data.getMaxEnergy());
            items.add((Object)data.stack);
            data = TransistorData.get(new ItemStack((Item)this));
            data.setMemory((byte)32);
            data.setUnlocked(-1);
            data.setAttack(0, TransistorFunctions.CRASH);
            data.setAttack(1, TransistorFunctions.BREACH);
            data.setAttack(2, TransistorFunctions.PING);
            data.setAttack(3, TransistorFunctions.JAUNT);
            data.setPassive(0, TransistorFunctions.HELP);
            data.setPassive(1, TransistorFunctions.CULL);
            data.setEnergy(data.getMaxEnergy());
            items.add((Object)data.stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        TransistorData data = TransistorData.get(stack);
        if (GuiScreen.func_146272_n()) {
            for (int i = 0; i < 4; ++i) {
                String num = i + 1 + ": ";
                if (i == data.getSelected()) {
                    num = TextFormatting.GREEN + num + TextFormatting.GRAY;
                }
                tooltip.add(num + data.getAttack(i).getDisplayName());
                for (int j = 0; j < 2; ++j) {
                    TransistorFunction upgrade = data.getUpgrade(i, j);
                    if (upgrade.isEmpty()) continue;
                    tooltip.add("   + " + upgrade.getDisplayName());
                }
            }
            tooltip.add("");
        }
        tooltip.add(I18n.func_135052_a((String)"transistor.energy", (Object[])new Object[0]) + ": " + TextFormatting.AQUA + data.getEnergy() + TextFormatting.GRAY + " / " + TextFormatting.AQUA + data.getMaxEnergy());
        tooltip.add(I18n.func_135052_a((String)"transistor.memory", (Object[])new Object[0]) + ": " + TextFormatting.GOLD + data.getUsedMemory() + TextFormatting.GRAY + " / " + TextFormatting.GOLD + data.getMemory());
        tooltip.add(I18n.func_135052_a((String)"transistor.xp", (Object[])new Object[0]) + ": " + TextFormatting.GREEN + data.getXP());
        if (GuiScreen.func_146271_m()) {
            tooltip.add("");
            tooltip.add(I18n.func_135052_a((String)"transistor.available_functions", (Object[])new Object[0]) + ": ");
            for (TransistorFunction function : TransistorFunctions.getAll()) {
                if (!data.isFunctionUnlocked(function)) continue;
                tooltip.add("  " + function.getDisplayName());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getHighlightTip(ItemStack stack, String displayName) {
        TransistorFunction function = TransistorData.get(stack).getSelectedAttack();
        if (!function.isEmpty()) {
            return displayName + ": " + function.getDisplayName();
        }
        return displayName;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        TransistorData data = TransistorData.get(stack);
        return data.getEnergy() > 0 && data.getEnergy() < data.getMaxEnergy();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        TransistorData data = TransistorData.get(stack);
        return 1.0 - MathHelper.func_151237_a((double)((double)data.getEnergy() / (double)data.getMaxEnergy()), (double)0.0, (double)1.0);
    }
}

