/*
 * Decompiled with CFR 0.152.
 */
package github.oaster2000.modjam5.entity;

import github.oaster2000.modjam5.items.ModItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.client.CPacketSteerBoat;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFlyingMachine
extends Entity {
    private static final DataParameter<Integer> FORWARD_DIRECTION = EntityDataManager.func_187226_a(EntityFlyingMachine.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(EntityFlyingMachine.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean>[] DATA_ID_PADDLE = new DataParameter[]{EntityDataManager.func_187226_a(EntityFlyingMachine.class, (DataSerializer)DataSerializers.field_187198_h), EntityDataManager.func_187226_a(EntityFlyingMachine.class, (DataSerializer)DataSerializers.field_187198_h)};
    private final float[] wingPositions = new float[2];
    private float momentum;
    private float outOfControlTicks;
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private boolean leftInputDown;
    private boolean rightInputDown;
    private boolean forwardInputDown;
    private boolean backInputDown;
    private boolean upInputDown;
    private boolean downInputDown;
    private double waterLevel;
    private float boatGlide;
    private double lastYd;

    public EntityFlyingMachine(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(1.375f, 0.5625f);
    }

    public EntityFlyingMachine(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FORWARD_DIRECTION, (Object)1);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        for (DataParameter<Boolean> dataparameter : DATA_ID_PADDLE) {
            this.field_70180_af.func_187214_a(dataparameter, (Object)false);
        }
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_70104_M() ? entityIn.func_174813_aQ() : null;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return -0.1;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (source instanceof EntityDamageSourceIndirect && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.setForwardDirection(-this.getForwardDirection());
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    this.func_145778_a(this.getItemMachine(), 1, 0.0f);
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof EntityFlyingMachine) {
            if (entityIn.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entityIn);
            }
        } else if (entityIn.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entityIn);
        }
    }

    public Item getItemMachine() {
        return ModItems.gear;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    public EnumFacing func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    public void func_70071_h_() {
        this.outOfControlTicks = 0.0f;
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        super.func_70071_h_();
        this.tickLerp();
        this.updateInputs();
        if (this.func_184186_bw()) {
            if (this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof EntityPlayer)) {
                this.setWingState(false, false);
            }
            this.updateMotion();
            if (this.field_70170_p.field_72995_K) {
                this.controlBoat();
                this.field_70170_p.func_184135_a((Packet)new CPacketSteerBoat(this.getWingState(0), this.getWingState(1)));
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        for (int i = 0; i <= 1; ++i) {
            this.wingPositions[i] = this.getWingState(i) ? (float)((double)this.wingPositions[i] + (double)0.3926991f) : 0.0f;
        }
        this.func_145775_I();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelectors.func_188442_a((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.field_70170_p.field_72995_K && !(this.func_184179_bs() instanceof EntityPlayer);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.func_184196_w((Entity)this)) continue;
                if (flag && this.func_184188_bt().size() < 2 && !entity.func_184218_aH() && entity.field_70130_N < this.field_70130_N && entity instanceof EntityLivingBase && !(entity instanceof EntityWaterMob) && !(entity instanceof EntityPlayer)) {
                    entity.func_184220_m((Entity)this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && !this.func_184186_bw()) {
            double d0 = this.field_70165_t + (this.lerpX - this.field_70165_t) / (double)this.lerpSteps;
            double d1 = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double d2 = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    private void updateMotion() {
        double d0 = -0.04f;
        double d1 = 0.0;
        double d2 = 0.0;
        this.momentum = 0.9f;
        this.field_70159_w *= (double)this.momentum;
        this.field_70179_y *= (double)this.momentum;
        this.deltaRotation *= this.momentum;
        this.field_70181_x *= (double)this.momentum;
        if (!this.func_184207_aI() && this.field_70160_al) {
            this.field_70181_x -= (double)0.9f;
        }
    }

    private void controlBoat() {
        if (this.func_184207_aI()) {
            float f = 0.0f;
            float g = 0.0f;
            if (this.leftInputDown) {
                this.deltaRotation += -1.0f;
            }
            if (this.rightInputDown) {
                this.deltaRotation += 1.0f;
            }
            if (this.rightInputDown != this.leftInputDown && !this.forwardInputDown && !this.backInputDown) {
                f += 0.005f;
            }
            this.field_70177_z += this.deltaRotation;
            if (this.forwardInputDown) {
                f += 0.04f;
            }
            if (this.upInputDown) {
                g += 0.08f;
            }
            if (this.downInputDown) {
                g -= 0.08f;
            }
            if (this.backInputDown) {
                f -= 0.005f;
            }
            double xo = f;
            double yo = g;
            double zo = f;
            this.field_70159_w += (double)MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * xo;
            this.field_70181_x += yo;
            this.field_70179_y += (double)MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * zo;
            this.setWingState(this.rightInputDown && !this.leftInputDown || this.forwardInputDown || this.upInputDown || this.downInputDown, this.leftInputDown && !this.rightInputDown || this.forwardInputDown || this.upInputDown || this.downInputDown);
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof EntityAnimal) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vec3d vec3d = new Vec3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + (double)f1, this.field_70161_v + vec3d.field_72449_c);
            passenger.field_70177_z += this.deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
            this.applyYawToEntity(passenger);
            if (passenger instanceof EntityAnimal && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((EntityAnimal)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    public void setWingState(boolean left, boolean right) {
        this.field_70180_af.func_187227_b(DATA_ID_PADDLE[0], (Object)left);
        this.field_70180_af.func_187227_b(DATA_ID_PADDLE[1], (Object)right);
    }

    public boolean getWingState(int side) {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_ID_PADDLE[side]) != false && this.func_184179_bs() != null;
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.outOfControlTicks < 60.0f) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        this.lastYd = this.field_70181_x;
        if (!this.func_184218_aH()) {
            if (onGroundIn) {
                if (this.field_70143_R > 3.0f) {
                    this.func_180430_e(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                            for (int i = 0; i < 3; ++i) {
                                this.func_70099_a(new ItemStack(this.getItemMachine()), 0.0f);
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.func_145778_a(Items.field_151055_y, 1, 0.0f);
                            }
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b()).func_185904_a() != Material.field_151586_h && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    public void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public void setForwardDirection(int forwardDirection) {
        this.field_70180_af.func_187227_b(FORWARD_DIRECTION, (Object)forwardDirection);
    }

    public int getForwardDirection() {
        return (Integer)this.field_70180_af.func_187225_a(FORWARD_DIRECTION);
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateInputs() {
        this.leftInputDown = GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74370_x);
        this.rightInputDown = GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74366_z);
        this.forwardInputDown = GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74351_w);
        this.backInputDown = GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74368_y);
        this.upInputDown = GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74314_A);
        this.downInputDown = GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_151444_V);
    }

    @SideOnly(value=Side.CLIENT)
    public float getFlyingTime(int side, float limbSwing) {
        return this.getWingState(side) ? (float)MathHelper.func_151238_b((double)((double)this.wingPositions[side] - (double)0.3926991f), (double)this.wingPositions[side], (double)limbSwing) : 0.0f;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.field_70165_t = this.lerpX;
            this.field_70163_u = this.lerpY;
            this.field_70161_v = this.lerpZ;
            this.field_70177_z = (float)this.lerpYaw;
            this.field_70125_A = (float)this.lerpPitch;
        }
    }

    public void func_70098_U() {
        if (this.func_184187_bx().field_70128_L) {
            this.func_184210_p();
            return;
        }
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.func_70071_h_();
        if (this.func_184187_bx() == null) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            return;
        }
        this.func_184232_k(this.func_184187_bx());
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer && this.func_184187_bx() != player) {
            return EnumActionResult.PASS;
        }
        if (!this.field_70170_p.field_72995_K) {
            player.func_184205_a((Entity)this, false);
        }
        return EnumActionResult.PASS;
    }

    public boolean shouldRiderSit() {
        return false;
    }
}

