/*
 * Decompiled with CFR 0.152.
 */
package github.oaster2000.modjam5.blocks;

import com.google.common.base.Preconditions;
import github.oaster2000.modjam5.blocks.BasicBlock;
import github.oaster2000.modjam5.blocks.BlockCrank;
import github.oaster2000.modjam5.blocks.BlockHandle;
import github.oaster2000.modjam5.blocks.BlockStoneGearBox;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModBlocks {
    public static BasicBlock crank;
    public static BasicBlock crankhandle;
    public static BasicBlock stonegb;

    public static void createBlocks() {
        crank = new BlockCrank("crank");
        crankhandle = new BlockHandle("crankhandle");
        stonegb = new BlockStoneGearBox("stonegearbox");
    }

    @SideOnly(value=Side.CLIENT)
    public static void initModels() {
        crank.initModel();
        crankhandle.initModel();
        stonegb.initModel();
    }

    @Mod.EventBusSubscriber(modid="davinci")
    public static class RegistrationHandler {
        public static final Set<ItemBlock> ITEM_BLOCKS = new HashSet<ItemBlock>();

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            ModBlocks.createBlocks();
            Block[] blocks = new Block[]{crank, crankhandle, stonegb};
            registry.registerAll((IForgeRegistryEntry[])blocks);
        }

        @SubscribeEvent
        public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
            ItemBlock[] items = new ItemBlock[]{new ItemBlock((Block)crank), new ItemBlock((Block)crankhandle), new ItemBlock((Block)stonegb)};
            IForgeRegistry registry = event.getRegistry();
            for (ItemBlock item : items) {
                Block block = item.func_179223_d();
                ResourceLocation registryName = (ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName(), (String)"Block %s has null registry name", (Object)block);
                registry.register(item.setRegistryName(registryName));
                ITEM_BLOCKS.add(item);
            }
        }
    }
}

